/*
 Copyright (C) 2011 Christian Dywan <christian@twotoasts.de>

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 See the file COPYING for the full license text.
*/

namespace Postler {
    public class Shortcuts : Gtk.Dialog {
        Gtk.ListStore store;
        Gtk.TreeView treeview;

        public Shortcuts (Gtk.Window parent, Gtk.ActionGroup action_group) {
            GLib.Object (transient_for: parent,
                         title: _("Keyboard Shortcuts"),
                         has_separator: false);

            var screen = get_screen ();
            Gdk.Rectangle monitor;
            screen.get_monitor_geometry (0, out monitor);
            double window_width = monitor.width / 1.7;
            double window_height = monitor.height / 1.7;
            set_default_size ((int)window_width, (int)window_height);

            store = new Gtk.ListStore (7, typeof (string), typeof (int),
                typeof (int), typeof (int), typeof (bool), typeof (string),
                typeof (Gtk.Action));
            treeview = new Gtk.TreeView.with_model (store);
            treeview.set_headers_visible (false);
            var column = new Gtk.TreeViewColumn ();
            var renderer = new Gtk.CellRendererText ();
            column.pack_start (renderer, false);
            column.add_attribute (renderer, "text", 0);
            treeview.append_column (column);
            column = new Gtk.TreeViewColumn ();
            renderer = new Gtk.CellRendererAccel ();
            column.pack_start (renderer, false);
            column.set_attributes (renderer, "accel-key", 1, "accel-mods", 2,
                "accel-mode", 3, "editable", 4);
            treeview.append_column (column);
            var content_area = get_content_area () as Gtk.Box;
            content_area.pack_start (new Postler.ScrolledWindow (treeview),
                                     true, true, 0);
            content_area.show_all ();

            foreach (var action in action_group.list_actions ()) {
                bool has_key = false;
                string? path = action.get_accel_path ();
                var key = new Gtk.AccelKey ();
                if (path != null)
                    has_key = Gtk.AccelMap.lookup_entry (path, out key);
                if (key.accel_key == 0)
                    continue;
                store.insert_with_values (null, int.MAX,
                                          0, action.label,
                                          1, key.accel_key,
                                          2, key.accel_mods,
                                          3, Gtk.CellRendererAccelMode.GTK,
                                          4, false,
                                          6, action);
            }
        }
    }
}
