#include "gld.h"
#include "sockets.h"

int GreyList(char *ip,char *sender,char *recipient,config *conf)
{
char query[QLEN];
long n;
int ts;
char *domain;
char netw[32];
int i,l;
char oip[32];
int a,b,c,d,x;
int fneither=0;
int fnotdomain=0;
int pid;
char osender[BLEN];
char orecipient[BLEN];

pid=getpid();

ts=time(0);
strcpy(oip,ip);
strcpy(osender,sender);
strcpy(orecipient,recipient);

if(conf->debug==1) printf("%d: Starting the greylist algo\n",pid);

//
// If we do lightgreylisting, then we just keep the network part of ip
//

if(conf->light==1)
	{
	if(conf->debug==1) printf("%d: lightgrey is on, let's remove the last octets of ips\n",pid);
        l=strlen(ip);
        for(i=l-1;i>=0;i--)
        	if(ip[i]=='.')
                       {
                       ip[i+1]='0';
                       ip[i+2]=0;
                       break;
                       }
	}

//
// If we do lightgrey domain, then we keep only the domain parts of sender and recipient
//

if(conf->lightd==1)
        {
        if(conf->debug==1) printf("%d: lightgrey on domain is on, let's keep the domain only on recipient and sender\n",pid);

        domain=(char *)strstr(osender,"@");
        if(domain!=NULL) strcpy(sender,domain);

        domain=(char *)strstr(orecipient,"@");
        if(domain!=NULL) strcpy(recipient,domain);
        }

//
// Do we have this entry in our database ?
//

sprintf(query,"select first from greylist where ip='%s' and sender='%s' and recipient='%s'",ip,sender,recipient);
n=SQLQuery(query);

if(conf->debug==1) printf("%d: Query=(%s) result=%ld\n",pid,query,n);

//
// If request failed, return the error
//
if(n<0) return(-1);

//
// if lightgreydomain is on and we don't have just the domain in database
// we check for the full triplet ip,osender,orecipient (ip versus oip incase lightd is on as well)
//
if(conf->lightd==1 && n==0)
        {
        sprintf(query,"select first from greylist where ip='%s' and sender='%s' and recipient='%s'",ip,osender,orecipient);
        n=SQLQuery(query);
        if(n<0) return(-1);
        if(n==0) fneither=1; else fnotdomain=1;
        if(conf->debug==1) printf("fneither is %d, fnotdomain is %d\n",fneither,fnotdomain);
        }

//
// if we don't have it in our database
// We do some whitelist checks before inserting it.
//

if(n==0)
	{
	//
	// First we check our local whitelist
	//
	if(conf->whitelist==1)
	{
		if(conf->debug==1) printf("%d: whitelist is on\n",pid);
		domain=(char *)strstr(osender,"@");
		if(domain==NULL) domain=osender;

		strcpy(netw,oip);
		l=strlen(netw);
		for(i=l-1;i>=0;i--)
			if(netw[i]=='.')
				{
				netw[i]=0;
				break;
				}


        sprintf(query,"select count(mail) from whitelist where mail in ('%s','%s','%s','%s')",osender,domain,oip,netw);
	n=SQLQuery(query);
	if(conf->debug==1) printf("%d: Query=(%s) result=%ld\n",pid,query,n);
	if(n>0)
		{
		if(conf->syslog==1) Log(conf,orecipient,osender,oip,MSGLOCALWL);
		return(1);
		}
	}

	//
	// Then we check the DNS Whitelist
	//
	if(conf->dnswl[0]!=0)
	{
		if(conf->debug==1) printf("%d: DNS whitelist is on\n",pid);
		x=sscanf(oip,"%d.%d.%d.%d",&a,&b,&c,&d);
		if(x==4)
			{
			sprintf(query,"%d.%d.%d.%d.%s",d,c,b,a,conf->dnswl);
			n=DnsIp(query,NULL);
			if(conf->debug==1) printf("%d: DNSQuery=(%s) result=%ld\n",pid,query,n);
			if(n==0)
				{
				if(conf->syslog==1) Log(conf,orecipient,osender,oip,MSGDNSWL);
				return(1);
				}
			}
	}

	//
	// If we are here, The mail was not in our database
	// was not whitelisted and thus we have to insert it
	//
	if(conf->lightd==1 && fneither==1)
                sprintf(query,"insert into greylist values('%s','%s','%s',%d,%d,1)",ip,osender,orecipient,ts,ts);

    	else sprintf(query,"insert into greylist values('%s','%s','%s',%d,%d,1)",ip,sender,recipient,ts,ts);

    	SQLQuery(query);
    	if(conf->debug==1) printf("%d: Query=(%s)\n",pid,query);
    	return(0);
    	}
else
	{
	//
	// If we are here, the mail was in our database
	// We only have to check if it is here for long enough
	// and update the database if needed.
	//

	if(conf->update==1)
		{
  		if(conf->lightd==1 && fnotdomain==1)
        		sprintf(query,"update greylist set last=%d,n=n+1 where ip='%s' and sender='%s' and recipient='%s'",ts,ip,osender,orecipient);

        	else sprintf(query,"update greylist set last=%d,n=n+1 where ip='%s' and sender='%s' and recipient='%s'",ts,ip,sender,recipient);

        	SQLQuery(query);
        	if(conf->debug==1) printf("%d: Query=(%s)\n",pid,query);
		}

	//
	// if we are doing lightd and the domain triplet isn't in the database
	// and we are going to accept the normal user triplet, add the domain triplet
	//

	if(ts-n>conf->mini && conf->lightd==1 && fnotdomain==1)
		{
		sprintf(query,"insert into greylist values('%s','%s','%s',%d,%d,1)",ip,sender,recipient,ts,ts);
		if(conf->debug==1) printf("Add the domain triplet for next time.\n");
		SQLQuery(query);
		}

	if(ts-n>conf->mini) return(1); else return(0);
	}
}
