SET(PONYPROG_REQUIRED_LIBRARIES)

SET(PONYPROG_OPTIONAL_LIBRARY_CONFIGURATIONS)
SET(PONYPROG_OPTIONAL_LIBRARIES)

MACRO(PONYPROG_CHECK_REQUIRED_DEPENDENCY FOUND LIBRARY URLS DESCRIPTION)
    LIST(APPEND PONYPROG_REQUIRED_LIBRARIES ${LIBRARY})
    IF(NOT ${FOUND})
        SET(MESSAGE_TEXT "Couldn't find ${LIBRARY}, which is required to build Ponyprog.")
        SET(MESSAGE_TEXT "${MESSAGE_TEXT} You can obtain ${LIBRARY} from")
        SET(DELIMITER "")
        FOREACH(URL ${URLS})
            SET(MESSAGE_TEXT "${MESSAGE_TEXT} ${DELIMITER} ${URL}")
            SET(DELIMITER "or")
        ENDFOREACH()
        SET(MESSAGE_TEXT "${MESSAGE_TEXT}.")
        SET(MESSAGE_TEXT "${MESSAGE_TEXT} ${DESCRIPTION}")
        MESSAGE(SEND_ERROR "${MESSAGE_TEXT}")
    ENDIF(NOT ${FOUND})
ENDMACRO(PONYPROG_CHECK_REQUIRED_DEPENDENCY)

MACRO(PONYPROG_CHECK_OPTIONAL_DEPENDENCY CONFIG FOUND LIBRARY)
    LIST(APPEND PONYPROG_OPTIONAL_LIBRARY_CONFIGURATIONS ${CONFIG})
    LIST(APPEND PONYPROG_OPTIONAL_LIBRARIES ${LIBRARY})

    IF(${CONFIG})
        IF(NOT ${FOUND})
            MESSAGE(SEND_ERROR "Couldn't find the ${LIBRARY} library, which is required by ${CONFIG}.")
        ENDIF(NOT ${FOUND})
    ENDIF(${CONFIG})
ENDMACRO(PONYPROG_CHECK_OPTIONAL_DEPENDENCY)

MACRO(PONYPROG_CHECK_NGUI_DEPENDENCY CONFIG)
    IF(${CONFIG} AND NOT PONYPROG_BUILD_NGUI_MODULE)
        MESSAGE(SEND_ERROR "PONYPROG_BUILD_NGUI_MODULE is required by ${CONFIG}.")
    ENDIF(${CONFIG} AND NOT PONYPROG_BUILD_NGUI_MODULE)
ENDMACRO(PONYPROG_CHECK_NGUI_DEPENDENCY)

MACRO(PONYPROG_CONDITIONAL_BUILD BUILD_OPTION BUILD_DIRECTORY)
    IF(${BUILD_OPTION})
        ADD_SUBDIRECTORY(${BUILD_DIRECTORY})
    ENDIF(${BUILD_OPTION})
ENDMACRO(PONYPROG_CONDITIONAL_BUILD)

MACRO(PONYPROG_ADD_LIBRARY LIBRARY_NAME)
    ADD_LIBRARY(${LIBRARY_NAME} ${ARGN})
    SET_TARGET_PROPERTIES(${LIBRARY_NAME} PROPERTIES VERSION "${PONYPROG_SO_VERSION}")
ENDMACRO()

