/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef POLYXMASS_UI_SEQED_WIDGET_H
#define POLYXMASS_UI_SEQED_WIDGET_H


#include "polyxmass-globals.h"
#include "polyxmass-monicon.h"


PxmRect monicon_rect;
gboolean scroll_size_changed;


gboolean kbd_alt_down ;
gboolean kbd_control_down;
gboolean kbd_meta_down;
gboolean kbd_shift_down;
gboolean kbd_selecting;
gboolean mouse_dragging;


/* Should be enough to write the number of the
   first monicon of each row.
*/
#define LEFT_MARGIN 64

/* Pixel-based size of the monomer icons in the two dimensions.
 */
#define MONICON_SIZE 32

/* Rougly Ten MONICON_SIZE large + LEFT_MARGIN - but recomputed, not very useful.
 */
#define SW_WIDTH 384

/* Two rows of monicons
 */
#define SW_HEIGHT 64

/* The number of pixels of the line that traces the polygon around the
   selected portion of the polymer sequence.
*/
#define SEL_POLYGON_LINE_WIDTH 3.0




#define PXM_TYPE_SEQED_WIDGET (polyxmass_seqed_widget_get_type ())
#define PXM_SEQED_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
PXM_TYPE_SEQED_WIDGET, PxmSeqedWidget))

#define PXM_SEQED_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
PXM_TYPE_SEQED_WIDGET, PxmSeqedWidgetClass))

#define PXM_IS_SEQED_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
PXM_TYPE_SEQED_WIDGET))

#define PXM_IS_SEQED_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), \
PXM_TYPE_SEQED_WIDGET))

#define PXM_SEQED_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
PXM_TYPE_SEQED_WIDGET, PxmSeqedWidgetClass))



typedef struct _PxmSeqedWidget PxmSeqedWidget;
typedef struct _PxmSeqedWidgetClass PxmSeqedWidgetClass;






struct _PxmSeqedWidget
{
  /* First the inheritance stuff : the parent structure.
   */
  GtkVBox parent_instance;

  /* Next stuff that belongs to the current structure proper.
   */
  
  /* The polchemdefctxt is absolutely necessary because when entering
     a sequence in this widget, we'll have to know how to render the
     monomers (ie where to search for the monicons if they exist
     already, or how to render them individually). 

     ***********NOT ALLOCATED.************ 
     
     Set to this widget by the caller which needs this widget, after
     proper creation of this widget.
  */
  PxmPolchemdefCtxt *polchemdefctxt; 
  


  /* The polymer is necessary because it is the object where the
     sequence is actually stored (in the polymer->monomerGPA
     GPtrArray, actually). 

     ***********NOT ALLOCATED.************ 
     
     Set to this widget by the caller which needs this widget, after
     proper creation of this widget.
   */
  PxmPolymer *polymer;
    


  /* The monomer code completions' window. Each sequence editing
     widget has one because the user might elicit the appearance of
     the codes upon TAB'ing in the editor widget. This window might or
     might not exist, as a full seqed_widget life can exist without a
     single TAB key stroke, that is without asking that the
     completions list be displayed in this window. So test if NULL
     when destroying the widget !
   */
  GtkWidget *monomer_code_completions_wnd;
  
  /* The scrolled window in which the canvas is packed. This one
     certainly exists !
   */
  GtkWidget *sw;

  /* We will need to know at each moment what's the size of the
     scrolled window.
   */
  gint sw_width;
  gint sw_height;

  /* Two holder variable to store the values of the
     scrolled window adjustments.
     
     ***********NOT ALLOCATED.************ 
     
  */
  GtkAdjustment *sw_vadjust;
  GtkAdjustment *sw_hadjust;
  
  /* The gnome-canvas in which all the graphics rendering takes
     place. This one certainly exists.
   */
  GtkWidget *canvas;
  
  /* The main canvas group under which all the monicon->canvas_item
   * elements of a single polymer sequence are set.
   */
  GnomeCanvasGroup *canvas_main_group;

  /* The points describing the selection polygon.
   */ 
  GnomeCanvasPoints *canvas_selection_points;
    
  /* The selection polygon that is drawn when user drags the mouse
   * on the polymer sequence.
   */
  GnomeCanvasItem *canvas_selection_polygon; 
    
  /* The label in which the position of the current monomer is
   * displayed.
   */
  GtkWidget *monomer_pos_label;

  GtkWidget *monicon_size_scale;
  
  /* The labels on the left of the sequence must have some place for them.
   * This is what the left margin is for.
   */
  gint left_margin;
  
  /* The size of the side of the square in which the monomer icon is
   * to be rendered (unit: pixel).
   */
  gint monicon_size;

  /* The canvas has to know real time what x and y offset it has. The
   * y offset is particularly important to calculate the position of the
   * scroll bars. The y offset is the number of pixels that are hidden
   * because of their coming out of the upper border of the scroll
   * window that contains the canvas.
   */
  gint canvas_x_offset;
  gint canvas_y_offset;

  /* The cursor is created for each polymer editing context.
   */
  PxmMonicon *cursor;
    
  /* Selection rectangle. This rectangle is where (x1,y1) and (x2,y2)
     points are stored so that it is each time possible to recalculate
     the index of the currently selected border monomers. This
     rectangle has its values updated each time the cursor changes
     location, either during a selection process (only the second pair
     changes (x2,y2) to indicate that the selection moves), or without
     selection, in which case (x1,y1) is set to current values of
     mouse position and (x2,y2) is set to the same values that (x1,y1)
     so that it is clear that no selection is going on.

     What should be understood is that x1,y1 and x2,y2 are not used to
     calculate the acutal selection polygon geometry. They are only
     values from which the index of the first monomer being in the
     selection and the index of the last monomer in that selection are
     being calculated. Once the indexes are known the precise geometry
     of the selection polygon is calculated by the
     polyxedit_seqed_wnd_update_sel_polygon () function.

     Finally, (x1,y1) and (x2,y2) pairs are either set to mouse cursor
     coordinates if the pointing on the sequence is performed by using
     the mouse, or these pairs' values are set by calculating the x,y
     position coordinates using a monomer index.
   */
  PxmRect selection_rect;
  
  /* We always need to know if there is a selection, what are
   * the two monomers that "border" the selection, this because
   * when the window is moved, resized, we have to be able to redraw
   * the full polymer sequence and restore the selection whose geometry
   * might have changed upon window size modification.
   */
  gint sel_mnm_idx1;
  gint sel_mnm_idx2;

  /* And we need these two rectangles to draw the selection polygon.
   */
  PxmRect mnm1rect;
  PxmRect mnm2rect;

  /* Number of monicons that can stand on a line of the sequence
   * editor window.
   */
  gint monicons_per_line;

  /* The last pointed monomer is the one on which the cursor was
   * clicked/unclicked. Variant _1_ is for button 1 of the mouse
   * (left).
   */
  gint last_point_1_idx;

  /* The last pointed monomer is the one on which the cursor was
   * clicked/unclicked. Variant _2_ is for button 2 of the mouse
   * (middle).
   */
  gint last_point_2_idx;
  
  /* The last pointed monomer is the one on which the cursor was
   * clicked/unclicked. Variant _3_ is for button 3 of the mouse
   * (right).
   */
  gint last_point_3_idx;
  
  /* The last moused monomer is the one on which the cursor was 
   * passed over.
   */
  gint last_mouse_idx;
  
  /* Currently elaborating monomer code string.
   */
  gchar *elab_code;

  /* Already completed code ready for evaluation.
   */
  gchar *eval_code;

  /* Holds how many characters already have been typed during the code
   * elaborating process (in the elab_code string holder)
   */
  gint kb_typed_chars;

  /* GtkEntry widget in the sequence editor context, where the elaborating 
   * monomer code is to be displayed.
   */
  GtkWidget *elab_code_entry;

  /* GtkEntry widget in the sequence editor context, where the non
   * abortive editing error messages are displayed, only in the
   * context of sequence editing.
   */
  GtkWidget *error_code_entry;

  /* GPtrArray* of the monicons that are created upon displaying of
  * a polymer sequence.
  */
  GPtrArray *moniconGPA;

  /* GPtrArray* of the labels that indicate the position in the
   * sequence, in the left margin.
   */
  GPtrArray *labelGPA;

  /* GData g_data_list to contain GQuark instances putting in relation
     pixbuf objects and a string, like for example the name or the
     code of a monomer. This is the place where the pointers to all
     the pixbuf's that are created to render the polymer sequence in
     the seqed_widget are stored. Each seqed_widget has its own set of
     pixbufs, along with its own array of monomer icons. There should
     never be a same pixbuf allocated twice.
   */
  GData *pixbufGData;
  
  /* Contains all the prop instances describing how to render a number
   * of visual effects. For example, this array contains all the data
   * necessary to render all the visuals required to highlight the
   * found sequences in a sequence.
   */
  GPtrArray *visualGPA;

  /* The conventional system of prop array. In particular, this array
     is used for the storage of clipboard selections.
   */
  GPtrArray *propGPA;  
};


struct _PxmSeqedWidgetClass
{
  GtkVBoxClass parent_class;

  void (* sequence_modified) (PxmSeqedWidget *seqed_widget);
  void (* sequence_not_modified) (PxmSeqedWidget *seqed_widget);
  void (* whole_seq_mass_update_required) (PxmSeqedWidget *seqed_widget);
  void (* selec_seq_mass_update_required) (PxmSeqedWidget *seqed_widget);
  void (* seq_left_end_modif_update_required) (PxmSeqedWidget *seqed_widget);
  void (* seq_right_end_modif_update_required) (PxmSeqedWidget *seqed_widget);
};


/*
****************************************************************
**************** SEQED_WIDGET CLASS FUNCTIONS ******************
****************************************************************
*/
GType 
polyxmass_seqed_widget_get_type (void) G_GNUC_CONST;

GtkWidget *
polyxmass_seqed_widget_new (void);

gboolean
polyxmass_seqed_widget_post_pack_constructor (PxmSeqedWidget *seqed_widget);

void 
polyxmass_seqed_widget_signal_sequence_modified (PxmSeqedWidget *seqed_widget,
						 gboolean true_false);
void
polyxmass_seqed_widget_signal_mass_update_required (PxmSeqedWidget *seqed_widget, 
						    PxmMasscalcTarget whole_selec);
void
polyxmass_seqed_widget_signal_seq_left_right_end_modif_update_required (PxmSeqedWidget *seqed_widget,
									PxmEnd left_right);




/*
****************************************************************
**************** SEQUENCE-MODIFYING FUNCTIONS ******************
****************************************************************
*/
gboolean
polyxmass_seqed_widget_remove_monomer (GtkWidget *widget, gint idx);

gint
polyxmass_seqed_widget_remove_selected_oligomer (GtkWidget *widget);

gint
polyxmass_seqed_widget_remove_sequence_indices (GtkWidget *widget,
						gint start, gint end);

gboolean
polyxmass_seqed_widget_integrate_monomer_at_idx (PxmMonomer *monomer,
						 gint idx,
						 GtkWidget *widget,
						 gboolean render_modif);
gboolean
polyxmass_seqed_widget_integrate_monomer_at_point (PxmMonomer *monomer,
						   GtkWidget *widget,
						 gboolean render_modif);

gint
polyxmass_seqed_widget_integrate_sequence_at_point (GPtrArray *GPA,
						    GtkWidget *widget,
						 gboolean render_modif);




/*
****************************************************************
*************    SEQUENCE (RE-) DRAWING FUNCTIONS   ************
****************************************************************
*/
gint
polyxmass_seqed_widget_render_polseq_monicons (GtkWidget *widget,
					       gboolean rerender);
gint 
polyxmass_seqed_widget_redraw_sequence (GtkWidget *widget);

void
polyxmass_seqed_widget_draw_cursor (GtkWidget *widget);

void 
polyxmass_seqed_widget_remove_selection_polygon (GtkWidget *widget);


void
polyxmass_seqed_widget_draw_sel_polygon (GtkWidget *widget);


gboolean
polyxmass_seqed_widget_update_sel_polygon (GtkWidget *widget);

void
polyxmass_seqed_widget_monicon_size_value_changed (GtkWidget *range,
						   gpointer data);





/*
****************************************************************
**************** VARIOUS  UTILITY   FUNCTIONS ******************
****************************************************************
*/
gboolean
polyxmass_seqed_widget_get_selection_indices (GtkWidget *widget,
					      gint *start, gint *end);

gint
polyxmass_seqed_widget_set_point_at_idx (GtkWidget *widget,
					 gint idx);

PxmMonomer *
polyxmass_seqed_widget_get_selected_monomer (GtkWidget *widget,
					     gint *idx);

gboolean
polyxmass_seqed_widget_monicon_get_pixel_coord (gint idx, 
						GtkWidget *widget, 
						PxmRect *rect, 
						PxmCoordsys coordsys1, 
						PxmCoordsys coordsys2);

gint
polyxmass_seqed_widget_get_mnm_idx_with_xy (GtkWidget *widget, 
					    gdouble mouse_x, 
					    gdouble mouse_y);

gboolean
polyxmass_seqed_widget_select_sequence (GtkWidget *widget,
					gint start_idx, gint end_idx);

gboolean 
polyxmass_seqed_widget_ensure_region_visible (GtkWidget *widget,
					      gint start_idx,
					      gint end_idx);

gboolean
polyxmass_seqed_widget_ensure_selection_and_cursor_visible (GtkWidget *sw, 
							    GdkEventConfigure *
							    event, 
							    gpointer data);
gint
polyxmass_seqed_widget_self_read_configuration (GtkWidget *widget);

void
polyxmass_seqed_widget_import_raw_text_file (GtkWidget *widget);





/*
****************************************************************
************** GTK_CLIPBOARD HANDLING FUNCTIONS ***************
****************************************************************
*/
void
polyxmass_seqed_widget_clipboard_primary_text_received (GtkClipboard *clipboard,
							const gchar *text,
							gpointer data);

void
polyxmass_seqed_widget_clipboard_clipboard_text_received (GtkClipboard *clipboard,
							  const gchar *text,
							  gpointer data);

void
polyxmass_seqed_widget_clipboard_text_received (GtkClipboard *clipboard,
						const gchar *text,
						gpointer data);

void
polyxmass_seqed_widget_clipboard_cut (GtkWidget *widget);

void
polyxmass_seqed_widget_clipboard_primary_copy (GtkWidget *widget);

void
polyxmass_seqed_widget_clipboard_clipboard_copy (GtkWidget *widget);


void
polyxmass_seqed_widget_clipboard_primary_paste (GtkWidget *widget);

void
polyxmass_seqed_widget_clipboard_clipboard_paste (GtkWidget *widget);



/*
****************************************************************
*************** EVENT/SIGNAL HANDLING FUNCTIONS ****************
****************************************************************
*/
gboolean
polyxmass_seqed_widget_canvas_event (GtkWidget *widget,
				     GdkEvent *event,
				     gpointer data);

gboolean 
polyxmass_seqed_widget_sw_size_allocate (GtkWidget *widget, 
					 GtkAllocation *allocation,
					 gpointer data);

gboolean
polyxmass_seqed_widget_canvas_item_event (GnomeCanvasItem *canvas_item,
					  GdkEvent *event, gpointer data);

gboolean
polyxmass_seqed_widget_sel_polygon_event (GtkWidget *widget,
					  GdkEvent *event,
					  gpointer data);









#endif  /* POLYXMASS_UI_SEQED_WIDGET_H */
