/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef LIBPOLYXMASS_ATOMSPEC_H
#define LIBPOLYXMASS_ATOMSPEC_H


#include "libpolyxmass-globals.h"


typedef struct _PxmAtomSpec PxmAtomSpec;


struct _PxmAtomSpec
{
  /* 
     Name of the polymer definition (ie polymer type, 'protein').
   */
  gchar *poltype;
  
  /* 
     Name of the atom definition (ie atom definition, 'basic').
   */
  gchar *atomdef;
  
  /* 
     Atom definition file (absolute name, as found in the catalogue
     files).
  */
  gchar* file;

  /* Finally we want to be able to trace from where the data for this
     polchemdefspec were read: system or user directory. Might be either
     CONFIG_SYSTEM or CONFIG_USER.
  */
  gint source;
};





/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmAtomSpec *
libpolyxmass_atomspec_new (void);

gboolean
libpolyxmass_atomspec_set_poltype (PxmAtomSpec *as, gchar *poltype);

gboolean
libpolyxmass_atomspec_set_atomdef (PxmAtomSpec *as, gchar *atomdef);

gboolean
libpolyxmass_atomspec_set_file (PxmAtomSpec *as, gchar *file);

gboolean
libpolyxmass_atomspec_set_source (PxmAtomSpec *as, gint source);





/*  LOCATING FUNCTIONS
 */


/* UTILITY FUNCTIONS
 */
gboolean
libpolyxmass_atomspec_reset (PxmAtomSpec *ps);



/* 
   The atom-defs.cat catalogue files.
*/
gboolean
libpolyxmass_atomspec_init_from_cat_line (gchar *line,
					  PxmAtomSpec *as) ;

gint
libpolyxmass_atomspec_parse_atom_defs_cat_file (gchar* file,
						GPtrArray *GPA,
						gint pre_ap_pend,
						gint sys_user);

gint
libpolyxmass_atomspec_parse_atom_defs_cat_files (GPtrArray *GPA,
						 gint pre_ap_pend,
						 gint sys_user);


/* 
   The polymer-def-atom-def.dic dictionary files.
*/
gboolean
libpolyxmass_atomspec_init_from_dic_line (gchar *line,
					  PxmAtomSpec *as);

gint
libpolyxmass_atomspec_parse_polchem_defs_atom_defs_dic_file (gchar* file,
							     GPtrArray *GPA,
							     gint pre_ap_pend);

gint
libpolyxmass_atomspec_parse_polchem_defs_atom_defs_dic_files (GPtrArray *GPA,
							      gint pre_ap_pend,
							      gint sys_user);

gint
libpolyxmass_atomspec_arrays_cross_complete_dic_cat_data (GPtrArray *dicGPA,
							  GPtrArray *catGPA);








/* FREE'ING FUNCTIONS
 */
gint
libpolyxmass_atomspec_free (PxmAtomSpec *as);



gint
libpolyxmass_atomspec_free (PxmAtomSpec *as);




/* GPtrArray-RELATED FUNCTIONS
 */
gint
libpolyxmass_atomspec_GPA_free (GPtrArray *GPA);



gint
libpolyxmass_atomspec_GPA_empty (GPtrArray *GPA);

gint
libpolyxmass_atomspec_GPA_free (GPtrArray *GPA);
















#endif 
/*
  #ifndef LIBPOLYXMASS_ATOMSPEC_H
*/





