/**
   Copyright (C) 2004 Cedric Pinson <cpinson@freesheep.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   ****************************************************************************
   * @file   profile.cxx
   *
   * @brief   Profile system
   *
   *****************************************************************************
   *
   * @author  Cedric Pinson, Based from article on Gems Game programming 3
   *	    Original authors GregHjelstrom and Byon Garrabrant
   *
   * @date    Created 2002/11
   *
   * @version $Id: profile.cpp,v 1.5 2004/09/30 16:28:34 izidor79 Exp $
   *
   ****************************************************************************/

#include "mafStdAfx.h"

#ifndef MAF_USE_VS_PCH
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <maf/profile.h>
#endif

#ifdef USE_PROFILE

#include <cstring>


Profile* GetProfiler() 
{
  static Profile* profile=0;
  if (!profile)
    profile=new Profile;
  return profile;
}

/// Total time reference
double ProfileNode::mGlobalTime=0;

/// Reference frame counter
unsigned int ProfileNode::mReferenceCount=0;

/// depth of profile
int ProfileNode::mFilter=0;



/** Main profile interface*/
Profile::Profile() 
{ 
  mRoot=new ProfileNode("PROFILE_ROOT"); 
  mCurrentNode=mRoot;
  mLevel=0; 
}

Profile::~Profile() 
{ 
  delete mRoot;
}


void Profile::StartProfile(const char *name) 
{ 
  ProfileNode *node;

  // recursif function
  if (mCurrentNode->GetName()==name) {
    mCurrentNode->AddCalls();
    mLevel++;
    return;
  }

  node=mCurrentNode->CheckSubName(name) ;
  if (!node) {
    node=new ProfileNode(name);
    mCurrentNode->AddNode(node);
  }

  node->StartProfile();
  mCurrentNode=node;
  mLevel++;
}

void Profile::StopProfile() 
{

  mLevel--;

  // it is a recursif function ? if no we stop profile
  if (mCurrentNode->GetLevel() == mLevel+1) {
    mCurrentNode->StopProfile();


    if (mCurrentNode->GetParent())
      mCurrentNode=mCurrentNode->GetParent();
  }
}



/** Sample implementation*/
Sample::Sample(const char *name) 
{ 
  GetProfiler()->StartProfile(name); 
}

Sample::~Sample()
{ 
  GetProfiler()->StopProfile(); 
}
#endif
