/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *
 */

#ifndef _UNDERWARE_H
#define _UNDERWARE_H

#ifdef _DEBUG // for Windows python23_d.lib is not in distribution... ugly but works
 #undef _DEBUG
 #include <Python.h>
 #define _DEBUG
#else
 #include <Python.h>
#endif


#define UNDERWAREAPI_LOCAL_ENTRY "_UNDERWARE_C_API"

/* BASE */
#define UNDERWAREAPI_BASE_FIRSTSLOT 0
#define UNDERWAREAPI_BASE_NUMSLOTS 2
#ifndef UNDERWAREAPI_BASE_INTERNAL

#define Vec32PyObject \
			(*(PyObject* (*)(const osg::Vec3& vec))UNDERWARE_C_API[UNDERWAREAPI_BASE_FIRSTSLOT + 0])

#define PyObject2Vec3 \
			(*(int (*)(const PyObject* p_vec, osg::Vec3* vec))UNDERWARE_C_API[UNDERWAREAPI_BASE_FIRSTSLOT + 1])

#define import_underware_base() { \
	PyObject *module = PyImport_ImportModule("underware.base"); \
	if (module != NULL) { \
		PyObject *dict = PyModule_GetDict(module); \
		PyObject *c_api = PyDict_GetItemString(dict, UNDERWAREAPI_LOCAL_ENTRY); \
		if(PyCObject_Check(c_api)) {\
			int i; void** localptr = (void**)PyCObject_AsVoidPtr(c_api); \
			for(i = 0; i < UNDERWAREAPI_BASE_NUMSLOTS; ++i) \
				UNDERWARE_C_API[i + UNDERWAREAPI_BASE_FIRSTSLOT] = localptr[i]; \
} Py_DECREF(module); } }
#endif


/* MAFApplication */
#define UNDERWAREAPI_MAFAPPLICATION_FIRSTSLOT 2
#define UNDERWAREAPI_MAFAPPLICATION_NUMSLOTS 2

class MAFApplication;

typedef struct {
  PyObject_HEAD
  MAFApplication* _MAFApplication;
} MAFApplication_Object;

#ifndef UNDERWAREAPI_MAFAPPLICATION_INTERNAL
#define MAFApplication_Check(x) (PyObject_TypeCheck((x), (PyTypeObject*)UNDERWARE_C_API[UNDERWAREAPI_MAFAPPLICATION_FIRSTSLOT + 0]))
#define mafapplication_Type (*(PyTypeObject*)UNDERWARE_C_API[UNDERWAREAPI_MAFAPPLICATION_FIRSTSLOT + 0])
#define PyMAFApplication_Check(x) (PyObject_TypeCheck((x), (PyTypeObject*)UNDERWARE_C_API[UNDERWAREAPI_MAFAPPLICATION_FIRSTSLOT + 1]))
#define pymafapplication_Type (*(PyTypeObject*)UNDERWARE_C_API[UNDERWAREAPI_MAFAPPLICATION_FIRSTSLOT + 1])

#define import_mafapplication() { \
	int i = 0; \
	PyObject *module = PyImport_ImportModule("underware.c_mafapplication"); \
	if (module != NULL) { \
		PyObject *dict = PyModule_GetDict(module); \
		PyObject *c_api = PyDict_GetItemString(dict, UNDERWAREAPI_LOCAL_ENTRY); \
		if(PyCObject_Check(c_api)) {\
			void** localptr = (void**)PyCObject_AsVoidPtr(c_api); \
			for(i = 0; i < UNDERWAREAPI_MAFAPPLICATION_NUMSLOTS - 1; ++i) \
				UNDERWARE_C_API[i + UNDERWAREAPI_MAFAPPLICATION_FIRSTSLOT] = localptr[i]; \
		} \
		Py_DECREF(module); \
	} \
	module = PyImport_ImportModule("underware.mafapplication"); \
	if (module != NULL) { \
		PyObject *dict = PyModule_GetDict(module); \
		PyObject *subtype = PyDict_GetItemString(dict, "MAFApplication"); \
		if(!PyObject_IsSubclass((PyObject*)subtype, (PyObject*)&mafapplication_Type)) { \
			PyErr_SetString(PyExc_TypeError, "MAFApplication must be derived from CMafapplication"); \
		} else { \
			UNDERWARE_C_API[i + UNDERWAREAPI_MAFAPPLICATION_FIRSTSLOT] = subtype; \
		} \
		Py_DECREF(module); \
	} \
}
#endif

/* Animated */
#define UNDERWAREAPI_ANIMATED_FIRSTSLOT 4
#define UNDERWAREAPI_ANIMATED_NUMSLOTS 2

class Animated;

typedef struct {
  PyObject_HEAD
  Animated* _Animated;
} Animated_Object;

#ifndef UNDERWAREAPI_ANIMATED_INTERNAL
#define Animated_Check(x) (PyObject_TypeCheck((x), (PyTypeObject*)UNDERWARE_C_API[UNDERWAREAPI_ANIMATED_FIRSTSLOT + 0]))
#define animated_Type (*(PyTypeObject*)UNDERWARE_C_API[UNDERWAREAPI_ANIMATED_FIRSTSLOT + 0])
#define PyAnimated_Check(x) (PyObject_TypeCheck((x), (PyTypeObject*)UNDERWARE_C_API[UNDERWAREAPI_ANIMATED_FIRSTSLOT + 1]))
#define pyanimated_Type (*(PyTypeObject*)UNDERWARE_C_API[UNDERWAREAPI_ANIMATED_FIRSTSLOT + 1])

#define import_animated() { \
	int i = 0; \
	PyObject *module = PyImport_ImportModule("underware.c_animated"); \
	if (module != NULL) { \
		PyObject *dict = PyModule_GetDict(module); \
		PyObject *c_api = PyDict_GetItemString(dict, UNDERWAREAPI_LOCAL_ENTRY); \
		if(PyCObject_Check(c_api)) {\
			void** localptr = (void**)PyCObject_AsVoidPtr(c_api); \
			for(i = 0; i < UNDERWAREAPI_ANIMATED_NUMSLOTS - 1; ++i) \
				UNDERWARE_C_API[i + UNDERWAREAPI_ANIMATED_FIRSTSLOT] = localptr[i]; \
		} \
		Py_DECREF(module); \
	} \
	module = PyImport_ImportModule("underware.animated"); \
	if (module != NULL) { \
		PyObject *dict = PyModule_GetDict(module); \
		PyObject *subtype = PyDict_GetItemString(dict, "Animated"); \
		if(!PyObject_IsSubclass((PyObject*)subtype, (PyObject*)&animated_Type)) { \
			PyErr_SetString(PyExc_TypeError, "Animated must be derived from CAnimated"); \
		} else { \
			UNDERWARE_C_API[i + UNDERWAREAPI_ANIMATED_FIRSTSLOT] = subtype; \
		} \
		Py_DECREF(module); \
	} \
}
#endif

#ifndef NO_UNDERWARE_C_API
#define UNDERWAREAPI_TOTALSLOTS 20
static void* UNDERWARE_C_API[UNDERWAREAPI_TOTALSLOTS] = {NULL};
#endif

#endif /* _UNDERWARE_H */
