/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Henry Prcheur <henry@precheur.org>
 *
 */

#include <string.h>
#include <gtk/gtk.h>
#include "network.h"

static int	g_list_size;
static GType	g_type_list[64]; // FIXME
static char*	g_title_list[64]; // FIXME

static GtkListStore*	make_list_store(void)
{
  int	i;

  static GType	type_table[] =
    {
      G_TYPE_INT,
      G_TYPE_STRING
    };
  g_list_size = get_int();
  g_message("list size %d", g_list_size);

  for (i = 0; i < g_list_size; i++)
    {
      int	type = get_int();

      g_message("type %d", type);
      g_type_list[i] = type_table[type];
    }

  for (i = 0; i < g_list_size; i++)
    {
      char* str = get_string();

      g_message("name %s", str);
      g_title_list[i] = str;
    }
  
  return gtk_list_store_newv(g_list_size, g_type_list);
}

static void	fill_list(GtkListStore* list_store)
{
  int	list_size = get_int();
  int	i;

  g_message("row count %d", list_size);
  for (i = 0; i < list_size; i++)
    {
      g_message("new row");
      GtkTreeIter	iter;

      gtk_list_store_append(list_store, &iter);

      int	j;
      for (j = 0; j < g_list_size; j++)
	{
	  GValue	value;
	  memset(&value, 0, sizeof (GValue));

	  switch (g_type_list[j])
	    {
	    case G_TYPE_STRING:
	      {
		char*	str = get_string();
		g_message("string: %s", str);
		g_value_set_string(g_value_init(&value, G_TYPE_STRING), str);
		g_free(str);
		gtk_list_store_set_value(list_store, &iter, j, &value);
		g_value_unset(&value);
	      }
	      break;
	    case G_TYPE_INT:
	      {
		int	integer = get_int();
		g_message("int: %d", integer);
		g_value_set_int(g_value_init(&value, G_TYPE_INT), integer);
		gtk_list_store_set_value(list_store, &iter, j, &value);
		g_value_unset(&value);
	      }
	      break;
	    default:
	      g_assert_not_reached();
	    }
	}
    }
  g_message("%s return", __FUNCTION__);
}

extern void	on_row_activated(GtkTreeView        *treeview,
				 GtkTreePath        *path,
				 GtkTreeViewColumn  *col,
				 gpointer            userdata);

void	lobby_new_tab(GtkNotebook* notebook)
{
  GtkListStore*	list_store = make_list_store(); // FIXME memleak!
  fill_list(list_store);

  GtkWidget*	treeview = gtk_tree_view_new_with_model(GTK_TREE_MODEL(list_store));

  g_signal_connect(treeview, "row-activated", (GCallback)on_row_activated, NULL);

  GtkCellRenderer*	cell_renderer = gtk_cell_renderer_text_new(); // FIXME
  int	i;
  for (i = 0; i < g_list_size; i++)
    {
      GtkTreeViewColumn*	column = gtk_tree_view_column_new();

      gtk_tree_view_column_set_title(column, g_title_list[i]);
      g_free(g_title_list[i]);
      gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
      
      gtk_tree_view_column_pack_start(column, cell_renderer, TRUE);
      gtk_tree_view_column_add_attribute(column, cell_renderer, "text", i);
    }
  /* label creation */
  char*	label_str = get_string();
  GtkWidget*	label = gtk_label_new(label_str);
  g_free(label_str);

  gtk_notebook_append_page(notebook, treeview, label);
}
