/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Henry Prcheur <henry@precheur.org>
 *
 */

#include <string.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include "gui.h"
#include "network.h"

static GtkWidget*	g_lobby_window;
static GtkWidget*	g_lobby_scrolled_window;
static GtkWidget*	g_lobby_notebook;
static GtkWidget*	g_lobby_title;
static GladeXML*	g_glade_lobby_xml = 0;

char* lobby_visible = 0;
void refresh_top_menu(void);

/*
 * forward declaration for lobby_tab.c
 */
void	lobby_new_tab(GtkNotebook* notebook);

void	notify_caller_quit(void)
{
  g_message("quit lobby");
  set_string("lobby");
  set_string("quit");
  set_int(0);
  flush_io_channel();
}

void	close_lobby(void)
{
  gtk_widget_hide_all(g_lobby_window);
  g_free(lobby_visible);  lobby_visible = 0; refresh_top_menu();
}

void	on_lobby_quit_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;

  notify_caller_quit();

  close_lobby();
}

void	on_lobby_refresh_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;

  g_message("refresh");
  set_string("lobby");
  set_string("refresh");
  set_int(0);
  flush_io_channel();
}

static void	send_id(int id)
{
  g_message("table selected %d", id);
  set_string("lobby");
  set_string("select");
  set_int(id);
  flush_io_channel();

  close_lobby();
}

void	on_lobby_ok_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;

  GtkWidget*	view =
    gtk_notebook_get_nth_page(GTK_NOTEBOOK(g_lobby_notebook),
			      gtk_notebook_get_current_page
			      (GTK_NOTEBOOK(g_lobby_notebook)));
  GtkTreeSelection*	selection;
  GtkTreeModel*	model;
  GtkTreeIter	iter;

  /* This will only work in single or browse selection mode! */
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
  if (gtk_tree_selection_get_selected(selection, &model, &iter))
    {
      int	id;

      gtk_tree_model_get (model, &iter, 0, &id, -1);
      send_id(id);
    }
  else
    g_message("no row selected.\n");
}

void	on_row_activated(GtkTreeView        *treeview,
			 GtkTreePath        *path,
			 GtkTreeViewColumn  *col,
			 gpointer            user_data)
{
  (void) col;
  (void) user_data;

  g_message("row clicked");
  GtkTreeModel*	model;
  GtkTreeIter   iter;

  model = gtk_tree_view_get_model(treeview);

  if (gtk_tree_model_get_iter(model, &iter, path))
    {
      int	id;

      gtk_tree_model_get(model, &iter, 0, &id, -1);
      g_message("Double-clicked row contains %d", id);
      send_id(id);
    }
  else
    g_warning("unable to find active row");
}

int	handle_lobby(void)
{
  g_message("ok");
  if (!g_glade_lobby_xml)
    {
      g_glade_lobby_xml = gui_load_widget("lobby_window");
      g_lobby_window = glade_xml_get_widget(g_glade_lobby_xml,
					    "lobby_window");
      g_assert(g_lobby_window);
      g_lobby_scrolled_window = glade_xml_get_widget(g_glade_lobby_xml,
						     "lobby_scrolled_window");
      g_assert(g_lobby_scrolled_window);
      g_lobby_title = glade_xml_get_widget(g_glade_lobby_xml,
					   "lobby_title");
      g_assert(g_lobby_title);
      g_lobby_notebook = gtk_notebook_new();
      gtk_widget_show(g_lobby_notebook);
      gtk_scrolled_window_add_with_viewport
	(GTK_SCROLLED_WINDOW(g_lobby_scrolled_window),
	 g_lobby_notebook);
      GUI_BRANCH(g_glade_lobby_xml, on_lobby_quit_clicked);
      GUI_BRANCH(g_glade_lobby_xml, on_lobby_refresh_clicked);
      GUI_BRANCH(g_glade_lobby_xml, on_lobby_ok_clicked);
      if(lobby_visible) g_free(lobby_visible);  lobby_visible = 0; refresh_top_menu();
    }

  if(lobby_visible) g_free(lobby_visible); lobby_visible = get_string(); refresh_top_menu();

  char*	title = get_string();
  gtk_label_set_text(GTK_LABEL(g_lobby_title), title);
  g_free(title);

  /* delete previous data */
  int	n_page = gtk_notebook_get_n_pages(GTK_NOTEBOOK(g_lobby_notebook));
  while (n_page--)
    gtk_notebook_remove_page(GTK_NOTEBOOK(g_lobby_notebook), n_page);

  int	tab_count = get_int();
  g_message("tab_count %d", tab_count);
  while (tab_count--)
    lobby_new_tab(GTK_NOTEBOOK(g_lobby_notebook));
  gtk_widget_set_size_request(g_lobby_scrolled_window, 500, 500);
  
  g_message("center");
  gui_center_window(GTK_WINDOW(g_lobby_window));

  return TRUE;
}
