/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#include <gtk/gtk.h>
#include <glade/glade.h>
#include <string.h>
#include <stdio.h>
#include "gui.h"
#include "network.h"

static GtkWidget*	g_in_position_window;
static GladeXML*	g_glade_in_position_xml = 0;
static GtkWidget*	scale = 0;
static GtkWidget*	button3 = 0;
static char* button3_label = 0;

void on_raise_value_changed(GtkRange *range,
			    gpointer user_data)
{
  (void) range;
  (void) user_data;

  gdouble value = gtk_range_get_value(GTK_RANGE(range));
  char tmp[128];
  snprintf(tmp, 128, button3_label, (int)value);
  gtk_button_set_label(GTK_BUTTON(button3), tmp);
}

void	on_button_clicked(GtkWidget *widget, gpointer user_data)
{
  (void) widget;
  (void) user_data;

  const char* name = gtk_widget_get_name(widget);
  set_string("in_position");
  set_int(name[strlen(name) - 1] - '1');
  set_int((int)gtk_range_get_value(GTK_RANGE(scale)));
  flush_io_channel();
}

int	handle_in_position(void)
{
  char*	tag = get_string();
  
  if (!g_glade_in_position_xml)
    {
      g_glade_in_position_xml = gui_load_widget("in_position_window");
      g_in_position_window = glade_xml_get_widget(g_glade_in_position_xml,
						  "in_position_window");
      g_assert(g_in_position_window);
      button3 = glade_xml_get_widget(g_glade_in_position_xml,
				     "button3");
      g_assert(button3);
      scale = glade_xml_get_widget(g_glade_in_position_xml,
				   "raise");
      g_assert(scale);
      GUI_BRANCH(g_glade_in_position_xml, on_raise_value_changed);
      GUI_BRANCH(g_glade_in_position_xml, on_button_clicked);
    }

  if(!strcmp(tag, "show"))
    {
      GtkWindow* window = GTK_WINDOW(g_in_position_window);
      int	window_width, window_height;
      int	screen_width = gdk_screen_width();
      int	screen_height = gdk_screen_height();

      gtk_widget_show_all(GTK_WIDGET(window));
      gtk_window_get_size(window, &window_width, &window_height);
      gtk_window_move(window,
		      (screen_width - window_width) / 2,
		      screen_height - window_height * 2);
    }
  else if(!strcmp(tag, "hide"))
    {
      gtk_widget_hide_all(g_in_position_window); 
    }
  else if(!strcmp(tag, "set"))
    {
      int raise_min = get_int();
      int raise_max = get_int();
      int raise_step = get_int();
      int to_call = get_int();
      
      int i;
      for(i = 1; i <= 3; i++) {
	char tmp[32];
	snprintf(tmp, 32, "button%d", i);
	GtkWidget* button = glade_xml_get_widget(g_glade_in_position_xml,
						 tmp);
	char* label = get_string();
	if(strlen(label) > 0) {
	  gtk_widget_show(button);
	} else {
	  gtk_widget_hide(button);
	}
	gtk_button_set_label(GTK_BUTTON(button), label);
	if(button3_label) g_free(button3_label); button3_label = g_strdup(label);
	g_free(label);
      }

      {
	if(raise_max != raise_min) {
	  gtk_scale_set_draw_value(GTK_SCALE(scale), TRUE);
	  gtk_range_set_range(GTK_RANGE(scale), raise_min, raise_max);
	  gtk_range_set_increments(GTK_RANGE(scale), raise_step, raise_step);
	  gtk_range_set_value(GTK_RANGE(scale), raise_min);
	  gtk_widget_show(scale);
	  on_raise_value_changed(scale, 0);
	} else {
	  gtk_range_set_value(GTK_RANGE(scale), 0);
	  gtk_widget_hide(scale);
	}
      }
    }

  g_free(tag);

  return TRUE;
}
