/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Henry Prcheur <henry at precheur dot org>
 *
 */
#include <gtk/gtk.h>
#include <glade/glade.h>
#include "gui.h"

#ifndef	GLADE_FILE
#	define	GLADE_FILE "bad glade file"
#endif // GLADE_FILE

GladeXML*	gui_load_widget(const char* widget_name)
{
  char*	filename = GLADE_FILE;

  if (g_file_test("interface.glade", G_FILE_TEST_EXISTS))
    filename = "interface.glade";
  else if (g_file_test("../../poker3d-interface/interface.glade", G_FILE_TEST_EXISTS))
    filename = "../../poker3d-interface/interface.glade";
  GladeXML*	xml = glade_xml_new(filename, widget_name, NULL);
  if (!xml)
    {
      g_critical("unable to load glade file %s", filename);
      return NULL;
    }
  return xml;
}

/*
 * Centering window callbacks
 */

static void	gui_center_move_window(GtkWindow* win, int ww, int wh)
{
  int	screen_width = gdk_screen_width();
  int	screen_height = gdk_screen_height();

  gtk_window_move(win,
		  (screen_width - ww) / 2,
		  (screen_height - wh) / 2);
}

static void	gui_center_show_callback(GtkWidget*	widget,
					 gpointer	user_data)
{
  (void) user_data;
  
  GtkWindow*	window = GTK_WINDOW(widget);

  int	win_w, win_h;

  gtk_window_get_size(window, &win_w, &win_h);
  gui_center_move_window(window, win_w, win_h);
}

static void	gui_center_size_callback(GtkWidget*	widget,
					 GtkAllocation*	allocation,
					 gpointer	user_data)
{
  (void) user_data;

  GtkWindow*	win = GTK_WINDOW(widget);
  
  gui_center_move_window(win, allocation->width, allocation->height);
}

void	gui_center_window(GtkWindow* window)
{
  g_signal_connect(G_OBJECT(window), "show",
		   G_CALLBACK(gui_center_show_callback), 0);
  g_signal_connect(G_OBJECT(window), "size-allocate",
		   G_CALLBACK(gui_center_size_callback),
		   0);
  gtk_widget_show_all(GTK_WIDGET(window));
}

/*
 * bottom left window callbacks
 */

static void	gui_bottom_left_move_window(GtkWindow* win, int wh)
{
  int	screen_height = gdk_screen_height();

  gtk_window_move(win, 0, screen_height - wh);
}

static void	gui_bottom_left_size_callback(GtkWidget*	widget,
					      GtkAllocation*	allocation,
					      gpointer	user_data)
{
  (void) user_data;

  GtkWindow*	win = GTK_WINDOW(widget);

  gui_bottom_left_move_window(win, allocation->height);
}

static void	gui_bottom_left_show_callback(GtkWidget*	widget,
					      gpointer	user_data)
{
  (void) user_data;
  
  GtkWindow*	window = GTK_WINDOW(widget);

  int	win_w, win_h;

  gtk_window_get_size(window, &win_w, &win_h);
  gui_bottom_left_move_window(window, win_h);
}

void	gui_bottom_left_window(GtkWindow* window)
{
  g_signal_connect(G_OBJECT(window), "size-allocate",
		   G_CALLBACK(gui_bottom_left_size_callback), 0);
  g_signal_connect(G_OBJECT(window), "show",
		   G_CALLBACK(gui_bottom_left_show_callback), 0);
  gtk_widget_show_all(GTK_WIDGET(window));
}

/*
 * top right window callbacks
 */

static void	gui_top_right_move_window(GtkWindow* win, int ww)
{
  int	screen_width = gdk_screen_width();

  gtk_window_move(win, screen_width - ww, 0);
}

static void	gui_top_right_size_callback(GtkWidget*	widget,
					    GtkAllocation*	allocation,
					    gpointer	user_data)
{
  (void) user_data;

  GtkWindow*	win = GTK_WINDOW(widget);

  gui_top_right_move_window(win, allocation->width);
}

static void	gui_top_right_show_callback(GtkWidget*	widget,
					    gpointer	user_data)
{
  (void) user_data;
  
  GtkWindow*	window = GTK_WINDOW(widget);

  int	win_w, win_h;

  gtk_window_get_size(window, &win_w, &win_h);
  gui_top_right_move_window(window, win_w);
}

void	gui_top_right_window(GtkWindow* window)
{
  g_signal_connect(G_OBJECT(window), "size-allocate",
		   G_CALLBACK(gui_top_right_size_callback), 0);
  g_signal_connect(G_OBJECT(window), "show",
		   G_CALLBACK(gui_top_right_show_callback), 0);
  gtk_widget_show_all(GTK_WIDGET(window));
}
