/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *
 */

/*
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * Note: LICENSE is LGPL
 *
 */

#ifndef _wnc_image_h
#define _wnc_image_h

#ifdef MAF_USE_VS_PCH
#include <maf/wnc_win32x.h>
#endif

  class WncImage {

  public:

    typedef enum {
   OPAQUE=0,      // Reserved for toolkit extensions
	 PREFERRED=1,   // Image source can freely choose the encoding
	 // -------------------------------------------------
	 // "Raw" encodings
	 L=16,          // Luminance (grayscale) images
	 RGB=32,        // These are the
	 ABGR=64,       //    two main encodings we use     
	 RGBA=128,      // Used for OpenGL textures
	 ARGB=256,      // Quicktime "native format" ?
	 YpCbCr420=512, // Y'CbCr 4:2:0 (see www.inforamp.net/~poynton)
	                //    Image is stored with all Y' components,
	                //    then Cb (1/4), then Cr (1/4)
                     //    (is this what they call a "planar" format?)
	 // -------------------------------------------------
	 // "Cooked" encodings
	 JPEG=4096
    } Encoding ;

    static float BytesPerPixel(Encoding e) ;     // 0 if not applicable
    static unsigned int BytesPerImage(unsigned int w, unsigned int h, Encoding e) ;
    static bool pixelIsContiguous(Encoding e) ;  // Can we copy a pixel in one memcpy ?

    static char* EncodingName(Encoding e) ;
    static Encoding EncodingFromName(const char *name) ;

    struct StandardSize {
	 char *name ;
	 int width, height ;
    } ;
    // The list is sorted by decreasing size and terminated by {0,0,0}
    static StandardSize StandardSizes[] ;

    typedef enum {
	 NONE=0,      // Memory will survive after the image
	 DELETE=1,    // Memory has to be delete'd
	 FREE=2,      // Memory has to be free'd
	 FREEMEM=4    // Memory has to be FreeMem'd
    } FreeMethod ;

    static unsigned char *AllocMem(unsigned int size) ;
    static void FreeMem(unsigned char **ptr) ;

  private:

    unsigned int _width, _height ;
    Encoding _encoding ;
    unsigned char *_data ;
    unsigned int _size ;
    FreeMethod _fmethod ;

  public:

    WncImage(void) {
	 _width = _height = 0 ;
	 _encoding = OPAQUE ;
	 _data = 0 ;
	 _size = 0 ;
	 _fmethod = NONE ;
    }

    WncImage(unsigned int w, unsigned int h, Encoding e) {
	 _width = _height = 0 ;
	 _encoding = OPAQUE ;
	 _data = 0 ;
	 _size = 0 ;
	 _fmethod = NONE ;
	 prepareFor(w,h,e) ;
    }

    // Data of the new image will be *linked* to src's data
    WncImage(WncImage& src) ;              // Copy constructor
    WncImage& operator = (WncImage& src) ; // Copy assignement

    ~WncImage(void) { clear() ; }

    void clear(void) {
	 _width = _height = 0 ;
	 _encoding = OPAQUE ;
	 setData(0,0,NONE) ;
    }

    void prepareFor(unsigned int w, unsigned int h, Encoding e) ;

    void setDims(unsigned int w, unsigned int h) { _width = w ; _height = h ; }
    void setEncoding(Encoding e) { _encoding = e ; }
    void setData(unsigned char *d, unsigned int s, FreeMethod m) ;

    // src will loose data ownership (src._fmethod=NONE)
    void stealDataFrom(WncImage &src) ;
    // src remains the data owner (this->_fmethod=NONE)
    void linkDataFrom(WncImage &src) ;
    // This one allocates a new data buffer with AllocMem and uses
    // memcpy to *copy* data from src.
    void copyDataFrom(const WncImage &src) ;

    bool dataIsLinked(void) { return (_fmethod==NONE) ; }

    // This one makes sure that nobody else uses the same data
    // buffer. It uses memcpy to copy data from the old buffer to a
    // new one, allocated with AllocMem.
    void acquireData() ;

    unsigned int getWidth(void) ;
    unsigned int getHeight(void) ;
    Encoding getEncoding(void) const { return _encoding ; }
    unsigned char *getData(void) const { return _data ; }
    unsigned int getSize(void) const { return _size ; }
  } ;

  // ------------------------------------------------------------------


#endif // _wnc_image_h
