/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Vincent Caron <zerodeux@gnu.org>
 *
 */
#ifndef vs_URL_H_
#define vs_URL_H_

/*
 *
 * Copyright (C) Nicolas Roussel
 *
 * See the file LICENSE for information on usage and redistribution of
 * this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * Note: LICENSE is LGPL
 *
 */

/*
  See also :

    http://www.ics.uci.edu/pub/ietf/uri/rfc2396.txt
    http://www.ics.uci.edu/~fielding/
    http://www.ics.uci.edu/~fielding/url/
  */

#ifndef MAF_USE_VS_PCH
#include <string>
#include <maf/mafexport.h>
#endif

  // ----------------------------------------------------------------------------

  class MAF_EXPORT URL {

  private:

    bool _isAbsolute ;
    bool _isOpaque ;

    std::string _scheme ;
    std::string _user, _password ;
    std::string _host, _port ;
    std::string _path ;
    std::string _query ;
    std::string _fragment ;

    std::string _opaque ;
  
  public:

    typedef enum {
	 NONE = 0,
	 NORMAL = 1,
	 UNSAFE = 2,
	 RESERVED = 4
    } URLENCODING ;

    static std::string encodeForQuery(const std::string &src, int flags = NORMAL) ;

    static std::string decodeFromQuery(const std::string &src) ;

    static std::string getQueryArg(const std::string &q, const std::string &key) ;

    // --------------------------------------------------------------------------

    URL(void) {}
    URL(const std::string& s) { load(s) ; }

    void load(const std::string &url) ;

    bool isOpaque(void) const { return _isOpaque ; }

    std::string const getScheme(void) const { return _scheme ; }
    std::string const getUser(void) const { return _user ; }
    std::string const getPassword(void) const { return _password ; }
    std::string const getHost(void) const { return _host ; }
    std::string const getPort(void) const { return _port ; }
    std::string const getPath(void) const { return _path ; }
    std::string const getQuery(void) const { return _query ; }
    std::string const getFragment(void) const { return _fragment ; }
    std::string const getOpaque(void) const { return _opaque ; }

    void debug(std::ostream& out) const ;

  } ;

  // ----------------------------------------------------------------------------

#endif
