/*
*
* Copyright (C) 2004 Mekensleep
*
*	Mekensleep
*	24 rue vieille du temple
*	75004 Paris
*       licensing@mekensleep.com
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*
* Authors:
*  Igor Kravtchenko <igor@obraz.net>
*
*/

#ifndef MAF_RADIXSORT_H
#define MAF_RADIXSORT_H

#ifndef MAF_USE_VS_PCH
#include <maf/mafexport.h>
#endif

const int RADIX_SIZEBIGITEM = 64;

class RadixByteItem {
public:
	char		value;
	int			user;
};

class RadixShortItem {
public:
	short		value;
	int			user;
};

class RadixIntItem {
public:
	unsigned	value;
	int			user;
};

class RadixFloatItem {
public:
	float	value;
	int		user;
};

class RadixBigItem {
public:
	guchar	value[RADIX_SIZEBIGITEM];
	int		user;
};


class ByteRadix {
public:
	MAF_EXPORT ByteRadix(int size);
	MAF_EXPORT ~ByteRadix();
	MAF_EXPORT RadixByteItem** sort(RadixByteItem *src, int nbItems);

private:
	int				nbItems_;
	RadixByteItem	**pTmpListPtr1_;
	RadixByteItem	**pTmpListPtr2_;
};


class ShortRadix {
public:
	MAF_EXPORT ShortRadix(int size);
	MAF_EXPORT ~ShortRadix();
	MAF_EXPORT RadixShortItem** sort(RadixShortItem *src, int nbItems);

private:
	int				nbItems_;
	RadixShortItem	**pTmpListPtr1_;
	RadixShortItem	**pTmpListPtr2_;
};


class IntRadix {
public:
	MAF_EXPORT IntRadix(int size);
	MAF_EXPORT ~IntRadix();
	MAF_EXPORT RadixIntItem** sort(RadixIntItem *src, int nbItems);

private:
	int				nbItems_;
	RadixIntItem	**pTmpListPtr1_;
	RadixIntItem	**pTmpListPtr2_;
};


class FloatRadix {
public:
	MAF_EXPORT FloatRadix(int size);
	MAF_EXPORT ~FloatRadix();
	MAF_EXPORT RadixFloatItem** sort(RadixFloatItem *src, int nbItems);

private:
	int				nbItems_;
	RadixFloatItem	**pTmpListPtr1_;
	RadixFloatItem	**pTmpListPtr2_;
};


class BigRadix {
public:
	MAF_EXPORT BigRadix(int size);
	MAF_EXPORT ~BigRadix();
	MAF_EXPORT RadixBigItem** sort(RadixBigItem *src, int nbItems);

private:
	int				nbItems_;
	RadixBigItem	**pTmpListPtr1_;
	RadixBigItem	**pTmpListPtr2_;
};

#endif
