/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Henry Precheur <henry@precheur.org>
 *
 */

#ifndef maf_application2d_h 
#define maf_application2d_h

#ifndef MAF_USE_VS_PCH
#include <osg/Group>
#endif

#include <maf/vision.h>
#include <maf/data.h>

class XwncDesktop;
class MAFApplication2DAnimate;

class MAF_EXPORT MAFApplication2DModel : public MAFVisionModel
{
public:
  MAFApplication2DModel() {}
  virtual ~MAFApplication2DModel() { }

  virtual void Init(void);

  void SetDesktop(XwncDesktop* desktop) { mDesktop = desktop; }
  XwncDesktop*	GetDesktop(void) { return mDesktop; }
  
  osg::Group* GetNode(void) { return MAFVisionModel::GetNode()->asGroup(); }

protected:
  XwncDesktop*	mDesktop;
};

class MAF_EXPORT MAFApplication2DController : public MAFVisionController
{
  MAFApplication* mApplication; // hack for cursor !!!
public:
  MAFApplication2DController(MAFApplication* App): mApplication(App) {}
  virtual ~MAFApplication2DController() {}

  virtual bool Update(MAFApplication* application);

  virtual void Init(void);

  MAFApplication2DModel* GetModel(void) { return dynamic_cast<MAFApplication2DModel*>(MAFController::GetModel()); }
  virtual void HandleHit(MAFHit& hit);
  virtual void HandleNotHit();

  void	SetDefaultFocusedWindow(const std::string& window_name);

  std::map<std::string, MAFApplication2DAnimate*>& GetName2Animate();

protected:
  void	HandleKeyboard(SDL_Event* event);
  void	HandleMouse(SDL_Event* event);
  void	HandleDefault(SDL_Event* event);

  // HACK CURSOR
  void  FlushMotionEvent();

  unsigned long	mId;
  std::string	mFocusedWindowName;

  SDL_Event	mLastMouseEvent;
  float	mDeltaFlushMotion;
  bool	mNeedFlush;

  std::string	mDefaultFocusedWindowName;

  bool	mIsFocused;
  bool	mIsLocked;
};

#endif // maf_application2d_h
