/**
    Copyright (C) 2004 Cedric Pinson <cpinson@freesheep.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

 ****************************************************************************
 * @file   exg_point.h
 *
 * @brief   base for point exchange
 *
 *****************************************************************************
 *
 * @author  Cedric Pinson
 *
 * @date    Created 2001/04
 *
 * @version $Id: exg_point.h,v 1.20 2004/04/28 10:37:19 loic Exp $
 *
 ****************************************************************************/


#ifndef exg_point_h
#define exg_point_h

#include <exg/exg_basetypes.h>
#include <exg/exg_vector3.h>

namespace exg
{
  class Visitor;

  class EXG_EXPORT Point : public MapObjectPointer
  {

   protected:

    virtual ~Point() {}

   public:
    COMMON_FUNCTIONS(Point)

    /// Default constructor
    Point() {
      (*this)["position"]=new VectorFloat(3);
    }

    
    inline Vector3f GetPosition() const {
      const VectorFloat* data=(*find("position")).second->AsVectorFloat();
      return Vector3f((*data)[0],(*data)[1],(*data)[2]);
    }


    inline void SetPosition(float x,float y,float z) {
      VectorFloat* data=(*this)["position"]->AsVectorFloat();
      (*data)[0]=x;
      (*data)[1]=y;
      (*data)[2]=z;
    }

    inline void SetPosition(const Vector3f& v) {
      VectorFloat* data=(*this)["position"]->AsVectorFloat();
      (*data)[0]=v[0];
      (*data)[1]=v[1];
      (*data)[2]=v[2];
    }

    virtual Point* AsPoint(void) { return this; }
    virtual const Point* AsPoint(void) const { return this; }
    virtual int GetType(void) const { return POINT; }
    inline static Object* Create() { return new Point; }

    std::ostream& operator<<(std::ostream& o);
  };

}
#endif
