"""
Commodity functions and classes to manipulate dom trees in a more pythonic way
"""

from types import StringTypes
from xml.dom import minidom

#Overriding the minindom Element in order to handle also Text
class Element(minidom.Element):
    """ Element supporting text """
    def __init__(self, tagName, text='', attributes={}, parentNode=None):
        minidom.Element.__init__(self, tagName)
        if text:
            self.text = minidom.Text()
            self.text.data=text
            self.appendChild(self.text)
        else:
            self.text=None
        for attr,val in attributes.items():
            self.setAttribute(attr, val)
        
    def getText(self): 
        return self.text.data

    def setText(self, text):
        self.text.data=text

class ezel:
    """ easy DOM element creation """
    #stolen from twisted.web.microdom
    
    def __init__(self, _node='', **kw):
        """ keyword attributes must be strings """
        if type(_node) in StringTypes:
            _node = Element(_node)
        self._node=_node
        for k, v in kw.items():
            if k[0] == '_': k = k[1:]
            self._node.setAttribute(k, v)
    
    def text(self, data):
        t=minidom.Text()
        t.data=data
        self._node.appendChild(t)
        return self
    
    def __setitem__(self, key, val):
        """ keyword attributes must be strings """
        self._node.setAttribute(key, val)

    def __getitem__(self, key):
        return self._node.getAttribute(key)
    
    def add(self, name, **kw):
        """ keyword attributes must be strings """
        newNode = Element(name)
        self._node.appendChild(newNode)
        xf = ezel(newNode)
        for k, v in kw.items():
            if k[0] == '_':
                k = k[1:]
            xf[k]=v
        return xf
        
    def dom(self):
        return self._node


def get_text(node):
    """ getting all text from a node """
    s=''
    for c in [x for x in node.childNodes if x.nodeType==x.TEXT_NODE]:
        s+=c.data
    return s

def set_text(node, text):
    """ set text into a node """
    for c in  [x for x in node.childNodes if x.nodeType==x.TEXT_NODE]:
        node.removeChild(c)
    t=minidom.Text()
    t.data=text
    node.appendChild(t)

def get_children(node, name):
    """ get the children using their name """
    return [c for c in node.childNodes if c.localName==name]

def get_childrenNS(node, ns, name):
    """ get the children using their name """
    return [c for c in node.childNodes if c.localName==name and
        c.namespaceURI==ns]
    
def get_child(node, name):
    """ get the first child using its name """
    for c in node.childNodes:
        if c.localName==name: return c
        
def get_childNS(node, ns, name):
    """ get the first child using its name """
    for c in node.childNodes:
        if c.localName==name and c.namespaceURI==ns:
            return c

def has_child(node, name):
    """ true if node has a child named name """
    for c in node.childNodes:
        if c.nodeName==name:
            return 1
    return 0

def has_childNs(node, ns, name):
    """ true if node has a child named name """
    for c in node.childNodes:
        if c.nodeName==name and c.namespaceURI==ns:
            return 1
    return 0
