from xmlutils import *
from elements import Iq
import utils

#Namespaces URIs
ns_iq_register='jabber:iq:register'

class InBandRegistrationManager:

    def __init__(self, stream, username, password, **kw):
        """ pass all additional registration fields as keyword parameters """
        self._stream=stream
        self._registration_fields={'username': username,
            'password': password}
        self._registration_fields.update(kw)
        self.__id=0 #XXX this now should be unuseful
    
    def start(self):
        """ start the registration prcoess """
        #self._d_finished=defer.Deferred()
        self.requestRegistrationFields()
        #return self._d_finished
    
    def requestRegistrationFields(self):
        """ """
        _id=`self.__id`
        self.__id+=1
        iq=Iq(ttype='get', id=_id)
        iq.setQueryNS(ns_iq_register)
        d=self._stream.sendIq(iq)
        d.addCallback(self.gotRegistrationFields)
        d.addErrback(self.gotRegistrationFieldsError)

    def gotRegistrationFields(self, iq):
        """ got the registration fields """
        q=iq.getQueryNode()
        fields=[x.localName for x in q.childNodes if x.localName and x.localName!='instructions']
        _id=`self.__id`
        self.__id+=1
        iq=Iq(ttype='set', id=_id)
        q=iq.setQueryNS(ns_iq_register)
        if 'password' not in fields: fields.append('password')
        for f in fields:
            c=ezel(f)
            c.text(self._registration_fields.get(f,''))
            q.appendChild(c.dom())
        d=self._stream.sendIq(iq)
        d.addCallback(self.gotRegistrationResult)        
        d.addErrback(self.gotRegistrationResultError)
        
    def gotRegistrationFieldsError(self, fail):
        """ """
        if fail.type=='iq':
            iq=fail.value
            if self._stream.factory.debug: utils.debug(iq.toxml(), xml=1)
            
        self._stream.registrationError('')
    
    def gotRegistrationResult(self, iq):
        """ got the result of the registration process """
        if self._stream.factory.debug: utils.debug("Registration success")
        #XXX fix
        self._stream.registrationSuccess()
        #self._d_finished.callback(None)
    
    def gotRegistrationResultError(self, fail):
        """ got an error for the registration process """
        if fail.type=='iq':
            iq=fail.value
            if self._stream.factory.debug: utils.debug(iq.toxml(), xml=1)
        #XXX fix
        self._stream.registrationError('')
        #self._d_finished
