"""
(c) 2004 Fabio Forno
Handling Data Forms as in JEP-0004
"""
from xmlutils import *
import types

ns_dataforms='jabber:x:data'

class DataField:
    
    def __init__(self, element=None, var='', type='', label='', desc='',
        required=0):
        """ """
        
        if element: self._el=element
        else: self._el=ezel('field').dom()
        
        if var: self.setVar(var)
        if type: self.setType(type)
        if label: self.setLabel(label)
        if desc: self.setDesc(desc)
        if required: self.setRequired(1)

    def getVar(self): return self._el.getAttribute('var')
    def setVar(self,var): self._el.setAttribute('var', var)
    
    def getType(self): return self._el.getAttribute('type')
    def setType(self, type): self._el.setAttribute('type', type)

    def getLabel(self): return self._el.getAttribute('label')
    def setLabel(self, label): self._el.setAttribute('label', label)
    
    def isRequired(self):
        return has_child(self._el, 'required')
    
    def setRequired(self, val):
        el=self._el
        req=get_child(el, 'required')
        if val and not req: el.appendChild(ezel('required').dom())
        if not val and req: el.removeChild(req)
        
    def getDesc(self):
        e=get_child(self._el, 'desc')
        if e: return get_text(e)
        else: return 0
        
    def setDesc(self, desc):
        el=self._el
        c=get_child(el, 'desc')
        if c: el.removeNode(c)
        c=ezel('desc').text(desc)
        el.appendChild(c.dom())
    
    def getValues(self):
        return [get_text(x) for x in get_children(self._el, 'value')]
   
    def addValue(self, value):
        e=ezel('value').text(value)
        self._el.appendChild(e.dom())
    
    def delValues(self): #XXX useful?
        for v in get_children(self._el, 'value'):
            self._el.removeChild(v)
    
    def addOption(self, label='', value=''):
        o=ezel('option')
        if label: o['label']=label
        if value: o.add('value').text(value)
        self._el.appendChild(o.dom())
    
    def getOptions(self):
        options=[]
        for o in get_children(self._el, 'option'):
            v=get_child(o, 'value')
            options.append((o.getAttribute('label'), get_text(v)))
        return options
        
    def delOptions(self):
        for o in get_children(self._el, 'option'):
            self._el.removeChild(o)
        
    def getOptionValues(self):
        return [x[1] for x in self.getOptions()]
         
    def dom(self):
        """ """
        return self._el
        
class DataItem:

    def __init__(self, element=None, type='item'):
        """ type: '', 'reported', 'item' """
        self._fields=[]
        if element:
            self._el=element
            for f in get_children(element, 'field'):
                self._fields.append(DataField(f))
        else: self._el=ezel(type)
        
    def __getitem__(self, var):
        """ return the `var` field """
        for f in self._fields:
            if f.getVar()==var: return f
        raise KeyError
    
    def addField(self, var='', type='', label='', desc='', required=0, values=[], options=[]):
        """  """
        f=DataField(var=var, type=type, label=label, desc=desc,
            required=required)
        if __builtins__['type'](values)!=types.ListType: values=[values]
        for v in values: f.addValue(v)
        for l,o in options: f.addOption(l,o)
        self._el.appendChild(f.dom())
        self._fields.append(f)
        return f
           
    def getFields(self):
        return self._fields
    
    def delFields(self):
        while self._fields:
            f=self._fields.pop(0)
            self._el.removeChild(f.dom())
            
    def dom(self):
        """  """
        return self._el
        
class DataForm:

    def __init__(self, element=None, type='', title='', instructions=''):
        """ valid types: cancel, form, result, submit """
        
        if element: self._el=element
        else: self._el=ezel('x', xmlns=ns_dataforms).dom()
        
        self.data=DataItem(self._el)
        
        if type: self.setType(type)
        if title: self.setTitle(title)
        if instructions: self.setIntructions(instructions)
        
        reported=get_child(self._el, 'reported')
        if reported: self.reported=DataItem(reported)
        
        self._items=[]
        for i in get_children(self._el, 'item'):
            self._items.append(DataItem(i))
    
    def getType(self): return self._el.getAttribute('type')
    def setType(self, type): self._el.setAttribute('type', type)
    
    def getTitle(self):
        e=get_child(self._el, 'title')
        if e: return get_text(e)
        else: return ''
        
    def setTitle(self, title):
        el=self._el
        c=get_child(el, 'title')
        if c: el.removeNode(c)
        c=ezel('title').text(title)
        el.appendChild(c.dom())
    
    def getInstructions(self):
        e=get_child(self._el, 'instructions')
        if e: return get_text(e)
        else: return ''
        
    def setInstructions(self, instructions):
        el=self._el
        c=get_child(el, 'instructions')
        if c: el.removeNode(c)
        c=ezel('instructions').text(instructions)
        el.appendChild(c.dom())
    
    def addItem(self, item):
        self._items.append(item)
        self._el.appendChild(item)
    
    def delItems(self):
        while self._items:
            i=self._items.pop(0)
            el.removeChild(i.dom())
    
    def getItems(self):
        """ get the form items """
        return self._items
    
    def dom(self):
        return self._el
    
   
