/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Johan Euphrosine <johan@mekensleep.com>
 *  Cedric Pinson <cpinson@freesheep.org>
 *
 */


#ifndef _pokersound_h_
#define _pokersound_h_

#include <string>
#include <vector>

class MAFXmlData;


class SoundInit {
public:
  std::string mName;
  std::string mSoundName;
  std::string mAnchor;
  float mReferenceDistance;
  float mRolloff;
  SoundInit(const std::string& name,
	    const std::string& soundname,
	    const std::string& anchor,
	    float refDist=1,
	    float rolloff=1):mName(name),
			     mSoundName(soundname),
			     mAnchor(anchor),
			     mReferenceDistance(refDist),
			     mRolloff(rolloff){}
};



bool LoadSoundSettings(std::vector<SoundInit>& settings, MAFXmlData *data);

#endif
