/* *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Cedric Pinson <cpinson@freesheep.org>
 */

#ifndef _poker_fold_animation_h
#define _poker_fold_animation_h


#include <string>
#include <vector>

#include <osg/Vec2>
#include <osg/Vec3>
#include <osg/ref_ptr>
#include <osg/MatrixTransform>
#include <osg/Matrix>
#include <maf/interpolator.h>
#include <maf/bezier.h>

namespace osg
{
  class MultipleAnimationPathCallback;
}

class PokerApplication;

class PokerFoldAnimation 
{
public:

  PokerFoldAnimation(PokerApplication* game,MAFOSGData* seat);

  void StartSequence();
  void Update(const double dt);
  void ShowCard(int i);
  void HideCard(int i);


private:

  int mMoveCards;
  osg::Matrix mOriginalTransformShake;
  osg::Vec3 mTarget;
  osg::ref_ptr<osg::MatrixTransform> mTransformPosition;
  osg::ref_ptr<osg::MultipleAnimationPathCallback> mAnimationCallback;
  std::vector<osg::ref_ptr<osg::MatrixTransform> > mCards;

  double mMoveDuration;

};


#endif
