/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *
 */

#include "pokerStdAfx.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef WIN32
#include "config_win32.h"
#endif

#ifndef WIN32
#	include "PokerError.h"
#endif // WIN32

GQuark
underware_poker_error_quark (void)
{
  static GQuark q = 0;
  if (q == 0)
    q = g_quark_from_static_string ("underware-poker-error-quark");

  return q;
}

PokerError::PokerError(GError* error) : MAFError(error)
{
}

PokerError::PokerError(gint code, const gchar* format, ...) {
  va_list ap;
  va_start(ap, format);

  Init(UNDERWARE_POKER_ERROR, code, format, ap);

  va_end(ap);
}

PokerError::PokerError(GQuark domain, gint code, const gchar* format, ...) {
  va_list ap;
  va_start(ap, format);

  Init(domain, code, format, ap);

  va_end(ap);
}

PokerError::~PokerError() {
}

