/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Cedric Pinson <cpinson@freesheep.org>
 *
 */

#include "pokerStdAfx.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef WIN32
#include "config_win32.h"
#include <cstdio>
# define snprintf _snprintf
#endif


#ifndef WIN32
#include <PokerCursor.h>
#include <Poker.h>
#include <maf/cursor.h>
#include <maf/window.h>
#include <maf/maferror.h>
#endif

#include <osg/Node>


PokerCursor::PokerCursor(PokerApplication* game):mGame(game),
						 mCurrentCursor(STANDARD),
						 mCurrentCursorPrevious(STANDARD)
{
}


void PokerCursor::Init()
{
  MAFCursorModel* amodel=0;
  // select if the cursor is system or in GL
  const std::string &prefermouse = mGame->HeaderGet("sequence", "/sequence/cursor/@hardwarecursor");
  if (prefermouse=="yes") {
    MAFCursorModelGL* model=new MAFCursorModelGL(mGame);
    amodel=model;
    {
    const std::string &mouseUrl = mGame->HeaderGet("sequence", "/sequence/mouse/@url");
    const std::string &mouseName = mGame->HeaderGet("sequence", "/sequence/mouse/@name");
    MAFVisionData *visionData = mGame->mDatas->GetVision(mouseUrl);
    g_assert(visionData);
    MAFOSGData* mouseData =  dynamic_cast<MAFOSGData *>(visionData);
    g_assert(mouseData);
    osg::Node* cursorGL = mouseData->GetNode(mouseName);
    g_assert(cursorGL);
    model->mCursors.push_back(cursorGL);
    }

    {
    const std::string &mouseUrl = mGame->HeaderGet("sequence", "/sequence/mouse/@sitoutUrl");
    const std::string &mouseName = mGame->HeaderGet("sequence", "/sequence/mouse/@sitoutName");
    MAFVisionData *visionData = mGame->mDatas->GetVision(mouseUrl);
    g_assert(visionData);
    MAFOSGData* mouseData =  dynamic_cast<MAFOSGData *>(visionData);
    g_assert(mouseData);
    osg::Node* cursorGL = mouseData->GetNode(mouseName);
    g_assert(cursorGL);
    model->mCursors.push_back(cursorGL);
    }

  } else {

    MAFCursorModelSDL* model=new MAFCursorModelSDL;
    amodel=model;
    {
    const std::string &cursorUrl = mGame->HeaderGet("sequence", "/sequence/cursor/@url");
    MAFCursorData* cursor;
    cursor = mGame->mDatas->GetCursor(cursorUrl);
    if (!cursor) {
      g_debug("Cursor /sequence/cursor/@url not found %s",cursorUrl.c_str());
      assert(0);
    }
    SDL_Cursor* mouseData = cursor->GetOrCreateCursor();
    g_assert(mouseData);
    model->mCursors.push_back(mouseData);
    }

    {
    const std::string &sitoutUrl = mGame->HeaderGet("sequence", "/sequence/cursor/@sitoutUrl");
    MAFCursorData* cursor;
    cursor = mGame->mDatas->GetCursor(sitoutUrl);
    if (!cursor) {
      g_debug("Cursor /sequence/cursor/@sitoutUrl not found %s",sitoutUrl.c_str());
      assert(0);
    }
    SDL_Cursor* mouseData = cursor->GetOrCreateCursor();
    g_assert(mouseData);
    model->mCursors.push_back(mouseData);
    }    
  }

  mCursor=new MAFCursorController;
  mCursor->SetModel(amodel);
  mCursor->Init();
  mGame->SetCursor(mCursor);
  mCurrentCursorPrevious=mCurrentCursor=STANDARD;
  SetStandardCursor();
}


void PokerCursor::ShowCursor(bool state)
{
  mCursor->ShowCursor(state);
}

void PokerCursor::SetSitoutCursor()
{
  mCursor->SetCursor((int)SITOUT);
  mCurrentCursorPrevious=mCurrentCursor;
  mCurrentCursor=SITOUT;
}

void PokerCursor::SetStandardCursor()
{
  mCursor->SetCursor((int)STANDARD);
  mCurrentCursorPrevious=mCurrentCursor;
  mCurrentCursor=STANDARD;
}

void PokerCursor::RestoreCursor() 
{
  if (mCurrentCursor==mCurrentCursorPrevious)
    return;

  if (mCurrentCursor==SITOUT)
    SetStandardCursor();
  else 
    SetSitoutCursor();
}

void PokerCursor::WarpMouse(int x,int y)
{
  mCursor->WarpMouse(x,y);
}
