/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 * Henry Precheur	<henry at precheur dot org>
 * Cedric Pinson <cpinson@freesheep.org>
 */

#ifndef	_POKERCHIPSSTACK_H_
#define	_POKERCHIPSSTACK_H_

#include <map>
#include <vector>

#include <ugame/artefact.h>

namespace osg {
  class PositionAttitudeTransform;
};

namespace osgchips {
  class Stacks;
};

namespace betslider {
  class BetSlider;
};

class PokerApplication;
struct UGAMEBasicText;

class PokerChipsStackModel: public UGAMEArtefactModel
{
  void InitTooltip(PokerApplication* game);
public:
  PokerChipsStackModel(class PokerApplication* game);
  virtual ~PokerChipsStackModel();

  std::map<unsigned int,unsigned int> mChips;

  void ShowTooltip(bool state);

  unsigned int mValue;
  osg::ref_ptr<UGAMEBasicText> mTooltip;
  osg::ref_ptr<betslider::BetSlider> mSlider;
  osg::ref_ptr<osg::PositionAttitudeTransform> mSliderPosition;
  osg::ref_ptr<osgchips::Stacks> mStacks;
  int mX;
  int mY;
  bool mSelected;
};

class PokerChipsStackController: public UGAMEArtefactController
{
 public:
  PokerChipsStackController(PokerApplication* game);
  virtual ~PokerChipsStackController();
  
  PokerChipsStackModel*	GetModel() { return dynamic_cast<PokerChipsStackModel*>(MAFController::GetModel()); }

  const std::map<unsigned int,unsigned int>& GetChips() { return GetModel()->mChips;}
  void SetChips(const std::vector<int>& chips);
  void AddChips(const std::map<unsigned int,unsigned int>& chips);
  void SubChips(const std::map<unsigned int,unsigned int>& chips);

  void CreateSlider(PokerApplication* game);

  bool Update(MAFApplication* application);

  unsigned int GetSelectedValue() { return GetModel()->mValue; }
  void ResetSelectedValue() { GetModel()->mValue = 0; }

  void SetBetLimits(int min, int max, int step, int call);

 protected:
  void SyncChips();
};

#endif /* _POKERCHIPSSTACK_H_ */
