/*
 *
 * Copyright (C) 2004 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors:
 *  Loic Dachary <loic@gnu.org>
 *  Henry Prcheur <henry@precheur.org>
 *  Cedric Pinson <cpinson@freesheep.org>
 *  Igor Kravtchenko <igor@obraz.net>
 *
 */

#include "pokerStdAfx.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */
#ifdef WIN32
#include "config_win32.h"
#include <cstdio>
# define snprintf _snprintf
#endif


#include <osgDB/ReadFile>
#include <osgDB/WriteFile>
#include <osgDB/Registry>
#include <osg/BlendFunc>
#include <osg/LightSource>

#include <SDL/SDL.h>

#include <maf/data.h>
#include <maf/split.h>
#include <maf/maferror.h>
#include <maf/packets.h>
#include <maf/application2d.h>
#include <maf/animate2d.h>
#include <maf/wnc_source.h>
#include <maf/wnc_desktop.h>
#include <maf/window.h>
#include <maf/shadow.h>

#include <libintl.h>
#define _(String) gettext (String)

#include <ugame/ugameerror.h>
#include <ugame/text.h>
#include <ugame/artefact.h>
#include <ugame/animated.h>
#include <ugame/debug.h>

#include <osgchips/Stacks>

#ifndef WIN32
#	include <Poker.h>
#	include <PokerCard.h>
#	include <PokerPlayer.h>
#	include <PokerBody.h>
#	include <PokerApplication.h>
#	include <PokerCamera.h>
#	include <PokerSplashScreen.h>
#	include <PokerCardProjector.h>
#	include <PokerToolTip.h>
#       include <PokerCursor.h>
#endif // WIN32

#include <libintl.h>

struct PokerFps: public MAFVisionController
{
  PokerFps()
    : MAFVisionController()
  {
    mText = new UGAMEBasicText("none\nnone", 0);
  }

  void	Init()
  {
    MAFVisionController::Init();
    MAFVisionModel*	model = new MAFVisionModel;
    SetModel(model);
    model->SetNode(mText.get());
  }

  bool Update(MAFApplication* application)
  {
    if (application->HasEvent())
      return true;
    else
      {
	char	tmp[256];
	snprintf(tmp, sizeof (tmp), "%.1f fps\n%.4f spf",
		 static_cast<double>(application->GetFPS()),
		 static_cast<double>(GetDeltaFrame()/1000.0));
 	mText->setStringUTF8(std::string(tmp));
//  	UGAMEPlaceTextInHud(mText->getText(), osgText::Text::LEFT_BOTTOM,
//  			  application->GetWindow(true)->GetWidth(),
//  			  application->GetWindow(true)->GetHeight());
	return true;
      }
  }

  osgText::Text*	GetText()
  {
    return mText->getText();
  }

protected:
  osg::ref_ptr<UGAMEBasicText>	mText;
};

PokerApplication::PokerApplication() :
  mDatas(0),
  mDeck(0),
  mPyScheduler(0),
  mCursor(0),
  mShadowedGroup(NULL),
  mShadowFlag(false)
{
}

PokerApplication::~PokerApplication()
{
  if (mCursor)
    delete mCursor;
  mCursor=0;
}

void PokerApplication::PythonAccept(PyObject* pypacket) {
  if(IsRunning()) {
    osg::ref_ptr<MAFPacket> packet = new MAFPacket(GetPacketsModule(), pypacket);
    mPoker->PythonAccept(packet.get());
  }
}

void PokerApplication::SendPacket(const std::string &packetName)
{
  if(IsRunning()) {
    osg::ref_ptr<MAFPacket> packet = GetPacketsModule()->Create(packetName);
    packet->SetMember("serial", mPoker->GetModel()->mMe);
    packet->SetMember("game_id", mPoker->GetModel()->mGameSerial);
    PythonCall("sendPacket", packet.get());
  }
}

void PokerApplication::Load(void)
{
	//Sleep(10000);

  //
  // Load chips bank
  //
  osgDB::Registry::instance()->getDataFilePathList().push_back(HeaderGet("settings", "/settings/data/@path"));
  {
    osgchips::ChipBank::instance()->unserialize(GetHeaders()["sequence"], osgDB::Registry::instance());
  }

  mDatas = new MAFRepositoryData;
  mDatas->Load(HeaderGet("settings", "/settings/data/@path"));
  //mDatas->Load("\\\\ptinain\\data_jeu\\scene_poker_43");
  //mDatas->Load("\\\\mksp\\graph\\data_demo");
  
  
  if(GetAmetista())
    mDatas->XwncConnect("vnc://127.0.0.1:1/?password=spe");

  std::string sound = HeaderGet("settings", "/settings/sound");
  bool has_sound = sound == "yes" || sound == "on" || sound == "";


  if(has_sound) {
    std::string sounds=HeaderGet("settings", "/settings/data/@sounds");
    mDatas->Load(sounds);
  }

  UGAMEDebugSingleton::Init(GetScene()->GetModel()->mGroup.get());

  {
    std::string set_name = HeaderGet("sequence", "/sequence/set/@url");
    mSetData = dynamic_cast<MAFOSGData*>(mDatas->GetVision(set_name));
  }

  {
    std::string camera_name = HeaderGet("sequence", "/sequence/set/@camera");
    PokerCameraController* camera = new PokerCameraController(this);
    GetScene()->GetModel()->mCamera = camera;
    MAFCameraModel* from_model = mSetData->GetCamera(camera_name)->GetModel();
    mDefaultCamera = *from_model;
    MAFCameraModel* to_model = camera->GetModel();
    *to_model = *from_model;
    std::string time_to_reach_string = HeaderGet("sequence", "/sequence/cameras/@timeToReach");
    mCameraTimeToReach = atof(time_to_reach_string.c_str());

    AddController(camera);
  }

  SetPacketsModule("pokerpackets");

  mDeck = new PokerDeck(this);

  mPoker = new PokerController(this);
  AddController(mPoker.get());

#ifdef TEST_PERFORMANCE
  std::string count_duplicate_string = HeaderGet("sequence", "/sequence/test/@count");
#endif
  {
#ifdef TEST_PERFORMANCE
    if(count_duplicate_string == "0")
#endif
      GetScene()->GetModel()->mGroup->addChild(mSetData->GetGroup());

#if 1
    osg::StateSet* state = GetScene()->GetModel()->mScene->getGlobalStateSet();
    GetScene()->GetModel()->mScene->setLightingMode(osgUtil::SceneView::NO_SCENEVIEW_LIGHT);
    //
    // The set provides lights
    //
    for(std::vector<osg::ref_ptr<osg::LightSource> >::iterator i = mSetData->GetLights().begin();
	i < mSetData->GetLights().end();
	i++) {
      osg::LightSource* light = i->get();
      state->setAssociatedModes(light->getLight(), osg::StateAttribute::ON);
    }
#endif
  }
#ifdef TEST_PERFORMANCE
  int duplicates = atoi(count_duplicate_string.c_str());
  if(duplicates > 0) {
    std::string what_dup = HeaderGet("sequence", "/sequence/test/@what");
    std::string step_dup_string = HeaderGet("sequence", "/sequence/test/@step");
    int step_dup = atoi(step_dup_string.c_str());
    MAFVisionData* data = mDatas->GetVision(what_dup);
    for(int i = 0; i < duplicates; i++) {
      UGAMEArtefactModel* artefact_model;
      if(what_dup.find("cal3d") == std::string::npos)
	artefact_model = new UGAMEArtefactModel;
      else
	artefact_model = new UGAMEAnimatedModel;
      artefact_model->SetData(data);
      UGAMEArtefactController* controller;
      if(what_dup.find("cal3d") == std::string::npos)
	controller = new UGAMEArtefactController;
      else
	controller = new UGAMEAnimatedController;
	
      controller->SetModel(artefact_model);
      controller->Init();
      if(what_dup.find("cal3d") == std::string::npos)
	artefact_model->SetArtefact(((MAFOSGData*)data)->GetGroup());
      artefact_model->GetPAT()->setPosition(osg::Vec3(step_dup*i, 0.f, 0.f));
      GetScene()->Insert(controller);
    }
  }
#endif

  if(GetScene()->GetModel()->GetAudio()) {
    std::string url = HeaderGet("sequence", "/sequence/soundtrack/@url");
    if(url != "") {
      MAFAudioData* data = mDatas->GetAudio(url);
      if (!data) {
	g_warning("unable to load soundtrack %s", url.c_str());
      } else {
	  MAFAudioModel* audio_model = new MAFAudioModel;
	  audio_model->SetName(url);
	  audio_model->SetData(data);
	  audio_model->SetAmbient(true);
	  mSoundtrack = new MAFAudioController;
	  mSoundtrack->SetModel(audio_model);
	  mSoundtrack->Init();
	  mSoundtrack->BindToScene(GetScene());
	  mSoundtrack->Play();
      }
    } else {
      g_warning("no soundtrack");
    }
  }
  
  if(GetAmetista()) {
    MAFApplication2DModel* chat_model = new MAFApplication2DModel;
    chat_model->SetDesktop(mDatas->GetDesktop());
    mApplication2D = new MAFApplication2DController(this);
    mApplication2D->SetModel(chat_model);
    mApplication2D->Init();
    mApplication2D->SetDefaultFocusedWindow("conversation");
    MAFName2Animate& name2animate = mApplication2D->GetName2Animate();

    MAFApplication::PropertiesList properties_list = HeaderGetPropertiesList("sequence", "/sequence/application2d/window");

    for(MAFApplication::PropertiesList::iterator i = properties_list.begin(); i != properties_list.end(); i++) {
      MAFApplication::Properties& properties = *i;
      const std::string& name = properties["title"];

      MAFApplication2DAnimate* animate = new MAFApplication2DAnimate();
      name2animate[name] = animate;

      if(properties["slide"] != "") {
	int directionFlags = 0;
	if(properties["slide_axis"] == "x")
	  directionFlags |= MAFApplication2DSlide::AXIS_X;
	else if(properties["slide_axis"] == "y")
	  directionFlags |= MAFApplication2DSlide::AXIS_Y;
	else
	  directionFlags |= MAFApplication2DSlide::AXIS_Y;

	if(properties["slide_direction"] == "negative")
	  directionFlags |= MAFApplication2DSlide::DIRECTION_NEGATIVE;
	else if(properties["slide_direction"] == "positive")
	  directionFlags |= MAFApplication2DSlide::DIRECTION_POSITIVE;
	else
	  directionFlags |= MAFApplication2DSlide::DIRECTION_POSITIVE;

	MAFApplication2DSlide* slider;

	if(properties["slide"] == "slide")
	  slider = new MAFApplication2DSlide(directionFlags);
	else if(properties["slide"] == "slide_in_out")
	  slider = new MAFApplication2DSlideInOut(directionFlags);
	else
	  slider = new MAFApplication2DSlide(directionFlags);

	float delay = 500;
	if(properties["slide_delay"] != "")
	  delay = atof(properties["slide_delay"].c_str());
	slider->SetDelay(delay);

	slider->SetMouseTrigger(properties["mouseTrigger"] == "true");

	slider->SetVisible(properties["visible"] == "true");

	animate->push_back(slider);
      }

      if(properties["alpha"] != "") {
	MAFApplication2DAlpha* alpha = new MAFApplication2DAlpha(atof(properties["alpha"].c_str()));
	animate->push_back(alpha);
      }

      if(properties["background_left"] != "") {
	MAFApplication2DDecorateSquare* decorate = new MAFApplication2DDecorateSquare;
	float left = atof(properties["background_left"].c_str());
	float bottom = atof(properties["background_bottom"].c_str());
	float right = atof(properties["background_right"].c_str());
	float top = atof(properties["background_top"].c_str());
	decorate->SetGeometry(left, bottom, right, top);
	if(properties["background_border"] != "")
	  decorate->SetBorder(atof(properties["background_border"].c_str()));
	osg::Vec4 background(atof(properties["background_red"].c_str()) / 255,
			     atof(properties["background_green"].c_str()) / 255,
			     atof(properties["background_blue"].c_str()) / 255,
			     atof(properties["background_alpha"].c_str()));
	decorate->SetBackgroundColor(background);
	decorate->SetBorderColor(osg::Vec4(1.f, 1.f, 1.f, 1.f));
	animate->push_back(decorate);
      }
    }

    GetScene()->HUDInsert(mApplication2D.get());
    AddController(mApplication2D.get());
  }

#ifdef TEST_PERFORMANCE
  if(count_duplicate_string == "0")
#endif
   {
    std::string fps=HeaderGet("settings", "/settings/@fps");
    if (fps == "on")
      {
	PokerFps*	fps_counter = new PokerFps();
	
	fps_counter->Init();
	GetScene()->HUDInsert(fps_counter);
	AddController(fps_counter);
      }
   }


  //  g_debug("PokerApplication::Load: osg cache %d", osgDB::Registry::instance()->getUseObjectCacheHint());
  GetScene()->HUDRemove(mSplashScreen.get());
  RemoveController(mSplashScreen.get());
  mSplashScreen = 0;

  {
    PokerToolTipController*	pttc = new PokerToolTipController(this);
    GetScene()->HUDInsert(pttc);
    std::list<std::string> tooltips = HeaderGetList("sequence", "/sequence/tooltips/tooltip/@path");
    for(std::list<std::string>::iterator i = tooltips.begin();
	i != tooltips.end();
	i++)
      {
	GetScene()->RegisterPickCallback(*i, //mApplication2D.get());
					 pttc);
      }
    AddController(pttc);
  }

  mCursor=new PokerCursor(this);
  mCursor->Init();

  //Sleep(5000);

  const std::string &shadow = HeaderGet("settings", "/settings/shadow");
  if (shadow == "on") {
    mShadowFlag=true;
	  osg::Group *setData = mSetData->GetGroup();
	  MAFESCNData *data = (MAFESCNData*) mDatas->GetVision("groundShadow.escn");
	  osg::Group *groundShadow = data->GetGroup();

	  {
		  osg::Geode *geode = GetGeode(groundShadow);
		  osg::Drawable *drawable = geode->getDrawable(0);
		  osg::StateSet *ss = drawable->getOrCreateStateSet();
		  osg::BlendFunc *bf = new osg::BlendFunc();
		  bf->setFunction(GL_DST_COLOR, GL_ZERO);
		  ss->setMode(GL_BLEND, osg::StateAttribute::ON);
		  ss->setAttributeAndModes(bf, osg::StateAttribute::ON);
		  ss->setRenderBinDetails(1, "RenderBin");
	  }

	  {
		  mShadowedGroup = new osg::Group();
		  setData->addChild(mShadowedGroup);

		  osg::MatrixTransform *shad = (osg::MatrixTransform*) GetNode(setData, "transform_Table");
		  if (shad) {
			  shad->setMatrix( osg::Matrix::translate(0, 0, 0) );
			  mShadowedGroup->addChild(shad);
			  shad->getParent(0)->removeChild(shad);

			  osg::Geode *gg = (osg::Geode*) shad->getChild(0);
			  osg::Geometry *gm = (osg::Geometry*) gg->getDrawable(0);
			  osg::Vec3Array *array = (osg::Vec3Array*) gm->getVertexArray();
			  int size = array->size();
			  for (int i = 0; i < size; i++) {
				  osg::Vec3 &pt = (*array)[i];
				  pt.y() += 42.5f; // hack, fix me
			  }

			  mShadowedGroup->addChild(groundShadow);

			  osg::MatrixTransform *mt = new osg::MatrixTransform();
			  osg::Matrix mat = osg::Matrix::rotate(-osg::PI/2, osg::X_AXIS) *
				  osg::Matrix::translate(osg::Vec3(0, 650, 0));

			  mt->setMatrix( mat );
			  MAFAddShadowMapTo(setData, mShadowedGroup, mt, 1, 0.6f);
		  }
		  else {
			  g_debug("Cannot found transform table node");
		  }
	  }

  }

}

void PokerApplication::SplashScreen(void)
{
  UGAMEError::SetVerbose(HeaderGet("settings", "/settings/@verbose"));
  
  std::string sound = HeaderGet("settings", "/settings/sound");
  bool has_sound = sound == "yes" || sound == "on" || sound == "";

  SetScene(new MAFSceneController);
  {
    MAFSceneModel* model = new MAFSceneModel;
    GetScene()->SetModel(model);
    model->SetAudio(has_sound);
  }
  GetScene()->Init();
  GetWindow(true)->AddView(GetScene()->GetView());
  AddController(GetScene());

  mSplashScreen = new PokerSplashScreenController(this);
  AddController(mSplashScreen.get());
  GetScene()->HUDInsert(mSplashScreen.get());
  GetWindow(true)->Render();
}

void PokerApplication::Init(void)
{
#ifdef WIN32
#define LC_ALL 0
//#undef PACKAGE
#define PACKAGE "underware"
#define LOCALEDIR "."
#endif
  // FIXME, this line cause a bug card/interactor load.
  // very strange, maybe my version of gettext/libc has a bug ?
  // setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);
  Load();
}

void PokerApplication::OnExit(int code)
{
  g_debug("PokerApplication is leaving with exit code %d.\n", code);

  mSoundtrack = 0;
  UGAMEDebugSingleton::Uninit();
  g_assert(mPoker->referenceCount() == 1);
  mPoker = 0;
  RecursiveClearUserData(mApplication2D->GetModel()->GetNode());
  MAFName2Animate& name2animate = mApplication2D->GetName2Animate();
  for(MAFName2Animate::iterator i = name2animate.begin(); 
      i != name2animate.end();
      i++)
    delete i->second;
  g_assert(mApplication2D->referenceCount() == 1);
  mApplication2D = 0;
  GetWindow(true)->DelView(GetScene()->GetView());
  if(mDeck) delete mDeck;
  if(mDatas) delete mDatas;
  g_assert(GetScene()->referenceCount() == 1);
  SetScene(0);
}

class AnimatedVisitor : public osg::NodeVisitor {
public:
  AnimatedVisitor(const std::string& name) : osg::NodeVisitor(osg::NodeVisitor::TRAVERSE_ALL_CHILDREN), mNode(0), mName(name) {
    setNodeMaskOverride(0xffffffff);
  }

  virtual void apply(osg::Node& node) {
    if(node.getName().find(mName) != std::string::npos) {
      mNode = &node;
      if(node.getName() != mName)
	g_critical("animated searched %s but found %s (AMBIGUOUS MUST BE FIXED)", mName.c_str(), node.getName().c_str());
    } else
      traverse(node);
  }

  osg::Node* mNode;
  const std::string& mName;
};

//
// serial           : 234234 -> PokerBodyController
// serial/nodename  : 234/transform_foo -> osg::Node
// nodename         : transform_foo -> osg::Node
//
osg::Referenced* PokerApplication::SearchAnimated(const std::string& name) {
	std::vector<std::string> names = std::split(name, "/", 0);
  
  std::string nodename;
  osg::Node* node;

  if(isdigit(name[0])) {
    guint serial = atoi(name.c_str());
    std::map<guint,osg::ref_ptr<PokerPlayer> >& serial2player = mPoker->GetModel()->mSerial2Player;
    if(serial2player.find(serial) == serial2player.end())
      return 0;
    PokerPlayer* player = serial2player[serial].get();
    if(names.size() == 1)
      return player->GetBody();

    node = player->GetSeat()->GetModel()->GetArtefact();
    nodename = names[1];
  } else {
    node = GetScene()->GetModel()->mGroup.get();
    nodename = name;
  }

  AnimatedVisitor visitor(nodename);
  node->accept(visitor);
  return visitor.mNode;
}

void PokerApplication::MoveTo(const MAFCameraModel& target, 
	    const PokerCameraModel::PointFunctor& positionPointGenerator)
{
  MoveTo(target, positionPointGenerator, positionPointGenerator);
}

void PokerApplication::MoveTo(const MAFCameraModel& target, 
	    const PokerCameraModel::PointFunctor& positionPointGenerator,
	    const PokerCameraModel::PointFunctor& targetPointGenerator)
{
  PokerCameraController* camera = dynamic_cast<PokerCameraController*>(GetScene()->GetModel()->mCamera.get());
  camera->MoveTo(target, positionPointGenerator, targetPointGenerator);
}

