// ------------------------------------------------------------------------- //
// $Id: sdlwin.h,v 1.24 2004/01/06 19:57:12 weismann Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// ------------------------------------------------------------------------- //

#ifndef _SDLWIN_H_
#define _SDLWIN_H_

#if HAVE_CONFIG_H
# include <config.h>
#endif

#if HAVE_SDL
# if HAVE_SDL_H	// Win32 and MAC OS X
#  include <SDL.h>
# endif
# if HAVE_SDL_SDL_H
#  include <SDL/SDL.h>
# endif
#endif

#include "mainwindow.h"

// ------------------------------------------------------------------------- //

//! SDLWindow is a MainWindow implementation based on SDL
class SDLWindow : public MainWindow {
public:
	SDLWindow();
	virtual      ~SDLWindow();
	void         create_window(WindowGeometry &geometry, bool fullscreen);
	void         swap_buffers() { SDL_GL_SwapBuffers( ); }
	void         make_rasterfont(); 
	bool         event(bool block);
	void         toggle_fullscreen();
	void         set_resolution(std::string r) {
                    log_warning("Unable to set resolution from SDL variant");
                 };
	std::string  get_resolution() {return ""; };
	std::string  get_resolutions();
private:
	void         handle_event(SDL_Event *event); 
	Uint8        _video_bpp;
	Uint32       _video_flags;
	std::string _original_resolution;
	typedef      std::map<std::string, SDL_Rect*> _videomodes_;
	_videomodes_ _videomodes;
};

#endif	// _SDLWIN_H_

// ------------------------------------------------------------------------- //

