/*  
    pmacct (Promiscuous mode IP Accounting package)
    pmacct is Copyright (C) 2004 by Paolo Lucente
*/

/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


/* includes */
#include "pmacct.h"
#include "imt_plugin.h"

/* functions */
int build_query_server(char *path_ptr)
{
  struct sockaddr_un sAddr;
  int sd, rc;

  sd=socket(AF_UNIX, SOCK_STREAM, 0);
  if (sd < 0) {
    Log(LOG_ERR, "ERROR: cannot open socket.\n");
    exit(1);
  }

  sAddr.sun_family = AF_UNIX;
  strcpy(sAddr.sun_path, path_ptr); 
  unlink(path_ptr);
  
  rc = bind(sd, (struct sockaddr *) &sAddr,sizeof(sAddr));
  if (rc < 0) { 
    Log(LOG_ERR, "ERROR: cannot bind to file %s .\n", path_ptr);
    exit(1);
  } 

  chmod(path_ptr, S_IRUSR|S_IWUSR|S_IXUSR|
                  S_IRGRP|S_IWGRP|S_IXGRP|
                  S_IROTH|S_IWOTH|S_IXOTH);

  setnonblocking(sd);
  listen(sd, 1);
  Log(LOG_INFO, "OK: waiting for data on: %s .\n", path_ptr);

  return sd;
}


void process_query_data(int sd, unsigned char *buf, int len)
{
  struct acc *acc_elem = 0;
  struct bucket_desc bd;
  struct query_header *q;
  struct pkt_primitives empty_addr, addr;
  char lbuf[LARGEBUFLEN], *elem, *lbufptr;
  int packed=0, counter=0;
  int following_chain=0;
  unsigned int i;

  memset(&empty_addr, 0, sizeof(struct pkt_primitives));
  memset(lbuf, 0, LARGEBUFLEN);
  memcpy(lbuf, buf, len);

  /* arranging some pointer */
  q = (struct query_header *) lbuf;
  lbufptr = lbuf+sizeof(struct query_header);

  if (config.debug) Log(LOG_DEBUG, "Processing data received from client ...\n");

  if (config.imt_plugin_passwd) {
    if (!strncmp(config.imt_plugin_passwd, q->passwd, MIN(strlen(config.imt_plugin_passwd), 8)));
    else return;
  }

  elem = (char *) a;

  /* We should increase elegance ;) */
  if (q->type == WANT_STATS) {
    memset(lbuf, 0, LARGEBUFLEN);
    lbufptr = lbuf;
    for (i = 0; i < config.buckets; i++) {
      if (!following_chain) acc_elem = (struct acc *) elem;
      if (memcmp(&acc_elem->src_ip, &empty_addr, sizeof(struct pkt_primitives)) != 0) {
        if ((packed + sizeof(struct acc)) < LARGEBUFLEN) {
          memcpy(lbufptr, acc_elem, sizeof(struct acc));
          lbufptr += sizeof(struct acc);
          packed += sizeof(struct acc);
          if (config.debug) counter++;
        }
        else {
          if (config.debug) {
            Log(LOG_DEBUG, "Entries: %d\n", counter);
            counter = 0;
          }
          send (sd, lbuf, packed, 0);
          memset(lbuf, 0, LARGEBUFLEN);
          packed = 0;
          lbufptr = lbuf;
          memcpy(lbufptr, acc_elem, sizeof(struct acc));
          lbufptr += sizeof(struct acc);
          packed += sizeof(struct acc);
          if (config.debug) counter++;
        }
      }
      if (acc_elem->next != NULL) {
        if (config.debug) Log(LOG_DEBUG, "Following chain in reply ...\n");
        acc_elem = acc_elem->next;
        following_chain = TRUE;
        i--;
      }
      else {
        elem += sizeof(struct acc);
        following_chain = FALSE;
      }
    }
    if (config.debug) {
      Log(LOG_DEBUG, "Entries: %d\n", counter);
      counter = 0;
    }
    send (sd, lbuf, packed, 0);
  }
  else if (q->type == WANT_ERASE) {
    kill(getppid(), SIGUSR1);
    if (config.debug) Log(LOG_DEBUG, "DEBUG: cleared in-memory table.\n");
  }
  else if (q->type == WANT_STATUS) {
    memset(lbuf, 0, LARGEBUFLEN);
    lbufptr = lbuf;
    for (i = 0; i < config.buckets; i++) {

      /* Administrativia */
      following_chain = FALSE;
      bd.num = 0;
      bd.howmany = 0;
      acc_elem = (struct acc *) elem;

      do {
        if (following_chain) acc_elem = acc_elem->next;
        if (memcmp(&acc_elem->src_ip, &empty_addr, sizeof(struct pkt_primitives)) != 0) bd.howmany++;
        bd.num = i; /* we need to avoid this redundancy */
        following_chain = TRUE;
      } while (acc_elem->next != NULL);

      if ((packed + sizeof(struct bucket_desc)) < LARGEBUFLEN) {
        memcpy(lbufptr, &bd, sizeof(struct bucket_desc));
        lbufptr += sizeof(struct bucket_desc);
        packed += sizeof(struct bucket_desc);
      }
      else {
        if (config.debug) Log(LOG_DEBUG, "Sending status, up to bucket %d ...\n", i);
        send(sd, lbuf, packed, 0);
        memset(lbuf, 0, LARGEBUFLEN);
        packed = 0;
        lbufptr = lbuf;
        memcpy(lbufptr, &bd, sizeof(struct bucket_desc));
        lbufptr += sizeof(struct bucket_desc);
        packed += sizeof(struct bucket_desc);
      }
      elem += sizeof(struct acc);
    }
    send(sd, lbuf, packed, 0);
  }
  else if (q->type == WANT_MRTG) {
    memcpy(&addr, lbufptr, sizeof(struct pkt_primitives)); 
    if (config.debug) Log(LOG_DEBUG, "Searching into accounting structure ...\n");
    memset(lbuf, 0, LARGEBUFLEN);
    lbufptr = lbuf;
    acc_elem = search_accounting_structure(&addr);
    if (acc_elem == NULL) packed = sizeof(int); 
    else {
      memcpy(lbufptr, acc_elem, sizeof(struct acc));
      packed = sizeof(struct acc);
    }
    send(sd, lbuf, packed, 0);
  }
}

