/*
 * $Id: silkscreen.h,v 1.16 2003/08/12 14:09:45 matto Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2002, Mark Ian Lillywhite and Michael Nordstrom
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef PLUCKER_SILKSCREEN_H
#define PLUCKER_SILKSCREEN_H

#include "viewer.h"

#ifdef HAVE_HANDERA_SDK
#include <Silk.h>
#endif

#ifdef HAVE_SONYSLKW_H
#include <SonySlkw.h>
#endif

#ifdef HAVE_SONY_SDK
#ifdef vskResizeHorizontally
#define SONY_SILK_API   0x03
#else
#ifdef sonySysFtrNumVskVersion
#define SONY_SILK_API   0x02
#else
#define SONY_SILK_API   0x01
#endif /* sonySyFtrNumVskVersion */
#endif /* vskResizeHorizontally  */
#else
#define SONY_SILK_API   0
#endif /* HAVE_SONY_SDK */

#define NUM_OF_SILKSCREENS 3
typedef enum {
    SILKSCREEN_DOWN     = 0,
    SILKSCREEN_UP       = 1,
    SILKSCREEN_NONE     = 2,
    SILKSCREEN_UNKNOWN  = 255
} SilkScreenStatus;

typedef enum {
    noSilkScreen = 0,
    sonyV1SilkScreen = 1,
    sonyV2SilkScreen = 2,
    handeraSilkScreen = 4,
    sonyV3SilkScreen = 8,  /*horizontal*/
    unknownSilkScreen = 512
} SilkScreen;

/* These may one day break the PalmOS becuase these are 'technically'
   supposed to be reserved for licensees. We need to allocate a range
   so that we can properly catch toolbar events sitting on the silk
   screen. If the silkscreen breaks later, try changing these :)

   For more information, see Chars.h */
#define vchrPluckerMin             0x2000
#define vchrPluckerMax             0x200F

#define vchrPluckerDbase           ( vchrPluckerMin + LIBRARYCONTROL )
#define vchrPluckerOffset          ( vchrPluckerMin + OFFSETCONTROL )
#define vchrPluckerBookmark        ( vchrPluckerMin + BOOKMARKCONTROL )
#define vchrPluckerFind            ( vchrPluckerMin + FINDCONTROL )
#define vchrPluckerAgain           ( vchrPluckerMin + AGAINCONTROL )
#define vchrPluckerAutoscrollDecr  ( vchrPluckerMin + AUTOSCROLLDECRCONTROL )
#define vchrPluckerAutoscrollStop  ( vchrPluckerMin + AUTOSCROLLSTOPCONTROL )
#define vchrPluckerAutoscrollStart ( vchrPluckerMin + AUTOSCROLLSTARTCONTROL )
#define vchrPluckerAutoscrollIncr  ( vchrPluckerMin + AUTOSCROLLINCRCONTROL )
#define vchrPluckerLeft            ( vchrPluckerMin + LEFTCONTROL )
#define vchrPluckerHome            ( vchrPluckerMin + HOMECONTROL )
#define vchrPluckerRight           ( vchrPluckerMin + RIGHTCONTROL )

#ifdef HAVE_SILKSCREEN

extern SilkScreen SilkScreenType( void ) SILKSCREEN_SECTION;
extern Err SilkScreenInitialize( void ) SILKSCREEN_SECTION;
extern SilkScreenStatus GetSilkScreenStatus( void ) SILKSCREEN_SECTION;
extern SilkScreenStatus SetSilkScreenStatus( SilkScreenStatus changeTo ) SILKSCREEN_SECTION;
extern void ResetSilkScreen( void ) SILKSCREEN_SECTION;
extern void UpdateSilkVerticalOffset( const Char* offText ) SILKSCREEN_SECTION;
extern Err SilkScreenStop( void ) SILKSCREEN_SECTION;
extern void SetSilkScreen( void ) SILKSCREEN_SECTION;
extern void SilkVerifyChange( void ) SILKSCREEN_SECTION;
extern void SilkHandleChange( void ) SILKSCREEN_SECTION;
extern void SonySilkDisableResize( void ) SILKSCREEN_SECTION;
extern void SonySilkEnableResize( void ) SILKSCREEN_SECTION;

#else

#define SilkScreenType()                    noSilkScreen
#define SilkScreenInitialize()              (void) errNoSilkScreen
#define GetSilkScreenStatus()               SILKSCREEN_UNKNOWN
#define SetSilkScreenStatus( changeTo )     (void) SILKSCREEN_UNKNOWN
#define ResetSilkScreen()
#define UpdateSilkVerticalOffset( offText )
#define SilkScreenStop()
#define SetSilkScreen()
#define SilkVerifyChange()
#define SilkHandleChange()
#define SonySilkDisableResize()
#define SonySilkEnableResize()

#endif /* HAVE_SILKSCREEN */

#endif

