/*
 * $Id: libraryform.h,v 1.9 2003/02/22 16:30:08 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2002, Mark Ian Lillywhite and Michael Nordstrom
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef PLUCKER_LIBRARYFORM_H
#define PLUCKER_LIBRARYFORM_H

#include "viewer.h"
#include "genericfile.h"

#define dmAllCategoriesAdvanced    0xFFFF
#define NO_ROW                    -1
#define ONE_ROW                    1

/* initialize document info list */
extern void InitializeDocInfoList( void ) LIBRARYFORM_SECTION;

/* Return pointer to docinfo structure */
extern DocumentInfo* DocInfo( Int16 index ) LIBRARYFORM_SECTION;

/* Return index for selected document */
extern Int16 ReturnLastIndex( void ) LIBRARYFORM_SECTION;

/* Release allocated memory */
extern void ReleaseDocInfoList( void ) LIBRARYFORM_SECTION;

/* Check if in select categories mode */
extern Boolean IsSelectingCategoryFilter( void ) LIBRARYFORM_SECTION;

extern RectangleType *LibraryGetDisplayListBounds(Int16 row) LIBRARYFORM_SECTION;
extern UInt16 LibraryGetDisplayListIndex(Int16 row) LIBRARYFORM_SECTION;
extern void OpenNewDocument( UInt16 index ) LIBRARYFORM_SECTION;
extern void IconPopupList(UInt8 row) LIBRARYFORM_SECTION;
extern void ScrollUp( Int16 amount ) LIBRARYFORM_SECTION;
extern void ScrollDown( Int16 amount ) LIBRARYFORM_SECTION;
extern Int16 LibraryGetNumberOfRows() LIBRARYFORM_SECTION;
extern void LibrarySetLastIndexForRow(UInt8 row) LIBRARYFORM_SECTION;
extern Int16 LibraryGetFirstVisibleRow(void) LIBRARYFORM_SECTION;
extern UInt8 LibraryGetVisibleRows(void) LIBRARYFORM_SECTION;
extern void SelectNextCategory(void) LIBRARYFORM_SECTION;

/* Event handler for the document manager form */
extern Boolean LibraryFormHandleEvent( EventType* event );

#endif

