; plee-the-bear.nsi
;
; Windows installer for Plee The Bear

;--------------------------------

; The name of the installer
Name "Plee The Bear Windows installer"

; The file to write
OutFile plee-the-bear.exe

; The default installation directory
InstallDir "$PROGRAMFILES\Plee The Bear"
InstallDirRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\plee-the-bear" "UninstallString"

XPStyle on

;--------------------------------

Page license
Page directory
Page instfiles

;--------------------------------

LicenseData ..\GPL

;--------------------------------
Section "Install"

  ; Set output path to the installation directory.
  SetOutPath "$INSTDIR\data"
  
  File /r "..\data\font"
  File /r "..\data\gfx"
  File /r "..\data\lang"
  File /r "..\data\level"
  File /r "..\data\model"
  File /r "..\data\music"
  File /r "..\data\sound"
  File "game_description.win"

  SetOutPath "$INSTDIR\bin"

  File "..\bin\*.dll"
  File "..\bin\running-bear.exe"

  SetOutPath "$INSTDIR"

  File ..\GPL
  File ..\CCPL
  File ..\desktop\win\ptb.ico

  FileOpen $9 "$INSTDIR\plee-the-bear.bat" w
  FileWrite $9 "bin\running-bear --game=data\game_description.win$\r$\n"
  FileClose $9

  CreateDirectory "$SMPROGRAMS\Plee The Bear"

  SetOutPath "$INSTDIR"

  CreateShortCut "$SMPROGRAMS\Plee The Bear\Plee The Bear.lnk" "$INSTDIR\plee-the-bear.bat" "" "$INSTDIR\ptb.ico"
  CreateShortCut "$SMPROGRAMS\Plee The Bear\Uninstall.lnk" "$INSTDIR\uninst-plee-the-bear.exe"
  CreateShortCut "$DESKTOP\Plee The Bear.lnk" "$INSTDIR\plee-the-bear.bat" "" "$INSTDIR\ptb.ico"
SectionEnd ; end of "Install"

;--------------------------------
Section -PostInstall
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\plee-the-bear" "DisplayName" "Plee The Bear (uninstall)"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\plee-the-bear" "UninstallString" '"$INSTDIR\uninst-plee-the-bear.exe"'
  WriteUninstaller "uninst-plee-the-bear.exe"
SectionEnd

UninstallText "Ready to uninstall Plee The Bear."

;--------------------------------
Section "Uninstall"
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\plee-the-bear"
  Delete "$INSTDIR\uninst-plee-the-bear.exe"
  Delete "$INSTDIR\plee-the-bear.bat"
  Delete "$INSTDIR\GPL"
  Delete "$INSTDIR\CCPL"
  Delete "$INSTDIR\ptb.ico"
  Delete "$DESKTOP\Plee The Bear.lnk"

  RMDir /r "$SMPROGRAMS\Plee The Bear"
  RMDir /r "$INSTDIR\data"
  RMDir /r "$INSTDIR\bin"

SectionEnd
