/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file log_layer.hpp
 * \brief This layer displays log informations on the screen.
 * \author Julien Jorge
 */
#ifndef __PTB_LOG_LAYER_HPP__
#define __PTB_LOG_LAYER_HPP__

#include "engine/layer/gui_layer.hpp"
#include "gui/static_text.hpp"
#include <claw/log_stream.hpp>

namespace ptb
{
  /**
   * \brief This layer displays log informations on the screen.
   * \author Julien Jorge
   */
  class log_layer :
    public bear::engine::gui_layer,
    public claw::log_stream
  {
  public:
    log_layer();
    ~log_layer();

    void render( bear::visual::screen& screen );

    bool key_pressed( bear::input::keyboard::key_code key );

  private:
    void write( const std::string& str );

  private:
    /** \brief Tell if the bow must be drawn. */
    bool m_visible;

    /** \brief The lines of text to display. */
    std::vector<bear::gui::static_text*> m_lines;

    /** \brief Tell if we must append the next string to the last line of the
	current content. */
    bool m_append;

  }; // class log_layer
} // namespace ptb

#endif // __PTB_LOG_LAYER_HPP__
