/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file main_menu_layer.cpp
 * \brief Implementation of the ptb::main_menu_layer class.
 * \author Julien Jorge
 */
#include "ptb/layer/main_menu_layer.hpp"

#include "ptb/frame/frame_main_menu.hpp"

#include "engine/font_factory.hpp"
#include "engine/version.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param pos The position of the main window.
 */
ptb::main_menu_layer::main_menu_layer
( const claw::math::coordinate_2d<unsigned int>& pos )
  : m_engine_version( NULL,
                      bear::engine::font_factory::create
                      ("font/fixed_white-7x12.tga") )
{
  frame_main_menu* wnd = new frame_main_menu(this);

  wnd->set_position(pos);
  show_window( wnd );

  m_engine_version.set_auto_size(true);
  m_engine_version.set_text(BEAR_VERSION_STRING);
  m_engine_version.set_position
    ( get_size().x - m_engine_version.width() - m_engine_version.height(),
      get_size().y - 2 * m_engine_version.height() );
} // main_menu_layer::main_menu_layer()

/*----------------------------------------------------------------------------*/
/**
 * \brief Render the layer on a screen.
 * \param screen The screen on which we draw.
 */
void ptb::main_menu_layer::render( bear::visual::screen& screen )
{
  m_engine_version.render(screen);
  super::render(screen);
} // main_menu_layer::render()
