/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_wasp_fly.cpp
 * \brief Definition of the class describing the state when the wasp fly.
 * \author Sebastien Angibaud
 */


#ifndef __PTB_STATE_WASP_FLY_HPP__
#define __PTB_STATE_WASP_FLY_HPP__

#include "engine/pointer_to_player.hpp"
#include "ptb/item/wasp/state_wasp.hpp"

namespace ptb
{
  /**
   * \brief The class describing the state where the wasp fly.
   * \author Sebastien Angibaud
   */
  class state_wasp_fly : public state_wasp
  {
  public:
    state_wasp_fly(ptb::wasp* wasp_instance);
    virtual ~state_wasp_fly() {};

  public:
    virtual std::string get_name() const;
    virtual void start();
    virtual void progress( bear::universe::time_type elapsed_time );

  private:
    bool search_player() const;
    bool player_in_zone( const bear::universe::position_type& pos ) const;
    void next_position( bear::universe::position_type& origin,
                        bear::universe::position_type& target);
    void oriente();

  private:
    /** \brief Pointer to the first player. */
    bear::engine::pointer_to_player m_first_player;

    /** \brief Pointer to the second player. */
    bear::engine::pointer_to_player m_second_player;

    /** \brief Indicates if the item come back. */
    bool m_come_back;

    /** \brief Indicates the angle of the oscillation. */
    double m_oscillation_angle;

    /** \brief The current step of the way. */
    unsigned int m_current_step;

    /** \brief Indicates if the wasp have attacked. */
    bool m_have_attacked;

  }; // class state_wasp_fly
} // namespace ptb

#endif // __PTB_STATE_WASP_FLY_HPP__





