/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_wasp_dead.cpp
 * \brief Definition of the class describing the state when the wasp dead.
 * \author Sebastien Angibaud
 */
#ifndef __PTB_STATE_WASP_DEAD_HPP__
#define __PTB_STATE_WASP_DEAD_HPP__

#include "ptb/item/wasp/state_wasp.hpp"

namespace ptb
{
  /**
   * \brief The class describing the state where the wasp dies.
   * \author Sebastien Angibaud
   */
  class state_wasp_dead : public state_wasp
  {
  public:
    state_wasp_dead(wasp* wasp_instance);
    virtual ~state_wasp_dead() {};

  public:
    virtual std::string get_name() const;
    virtual void start();
    virtual void progress( bear::universe::time_type elapsed_time );
    virtual void set_bottom_contact(bear::universe::physical_item_state& item);
  
  private:
    void create_headstone() const;

  private:
    /** \brief Indicates if the wasp had a contact. */
    bool m_contact;

    /** \brief The item with contact. */
    bear::universe::physical_item_state* m_item_contact;

    /** \brief The energy of the soul of a wasp.*/
    static const unsigned int s_soul_energy;

  }; // class state_wasp_dead
} // namespace ptb

#endif // __PTB_STATE_WASP_DEAD_HPP__





