/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_wasp_attack.cpp
 * \brief Definition of the class describing the state when the wasp attack.
 * \author Sebastien Angibaud
 */

#ifndef __PTB_STATE_WASP_ATTACK_HPP__
#define __PTB_STATE_WASP_ATTACK_HPP__

#include "universe/physical_item_state.hpp"
#include "ptb/item/wasp/state_wasp.hpp"

namespace ptb
{
  /**
   * \brief The class describing the state when the wasp attack.
   * \author Sebastien Angibaud
   */
  class state_wasp_attack : public state_wasp
  {
  public:
    state_wasp_attack(wasp* wasp_instance);
    virtual ~state_wasp_attack() {};

  public:
    virtual std::string get_name() const;
    virtual void start();
    virtual void progress( bear::universe::time_type elapsed_time );

  private:
    void create_sting() const;
    double orientate_sting( bear::universe::speed_type speed ) const;
    bear::universe::position_type sting_position() const;
  private:
    /** \brief Number of iteration in an offensive. */
    unsigned int m_nb_iterations;

    /** \brief Index of the current sting. */
    unsigned int m_index_sting;

  }; // class state_wasp_attack
} // namespace ptb

#endif // __PTB_STATE_WASP_ATTACK_HPP__
