/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file stone.hpp
 * \brief The class describing a stone.
 * \author Sbastien Angibaud
 */
#ifndef __PTB_STONE_HPP__
#define __PTB_STONE_HPP__

#include "ptb/item/plee/plee.hpp"
#include "ptb/monster_item.hpp"
#include "engine/model.hpp"
#include "engine/base_item.hpp"

namespace ptb
{
  /**
   * \brief The class describing a stone.
   * \author Sbastien Angibaud
   */
  class stone:
    public monster_item< bear::engine::model<bear::engine::base_item> >
  {
  public:
    /** \brief The type of the parent class. */
    typedef monster_item< bear::engine::model<bear::engine::base_item> > super;

  public:
    stone( bear::engine::base_item::id_type id_creator );

    void start();
    void progress( bear::universe::time_type elapsed_time );
    void has_attacked();

    void left_active_region();

  private:
    /** \brief The identifiant of creator of the stone. */
    const bear::engine::base_item::id_type m_id_creator;

  }; // class stone
} // namespace ptb

#endif // __PTB_STONE_HPP__
