/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file plee.hpp
 * \brief The class describing the player (Plee).
 * \author Julien Jorge
 */
#ifndef __PTB_PLEE_HPP__
#define __PTB_PLEE_HPP__

#include "ptb/monster_item.hpp"
#include "engine/player.hpp"
#include "ptb/player_action.hpp"
#include "ptb/item/plee/state_plee.hpp"
#include "ptb/item_that_speaks.hpp"

namespace ptb
{
  /**
   * \brief The class describing the player (Plee).
   * \author Julien Jorge
   */
  class plee : 
    public item_that_speaks< monster_item<bear::engine::player> >
  {
  public:
    /** \brief The type of the parent class. */
    typedef item_that_speaks< monster_item<bear::engine::player> > super;

    enum plee_state_name
      {
        walk_state = 0,
        idle_state,
        jump_state,
        fall_state,
        dead_state,
        run_state,
        slap_state,
        start_jump_state,
        vertical_jump_state,
        look_up_state,
        crouch_state,
        captive_state,
        start_throw_state,
        throw_state,
        wait_state
      }; // enum plee_state

  public:
    plee();
    ~plee();

    virtual void progress( bear::universe::time_type elapsed_time );
    virtual
    void get_visual( std::list<bear::engine::scene_visual>& visuals ) const;
    void start();
    void save_position();

    virtual void start_action( action a );
    virtual void do_action( action a );
    virtual void stop_action( action a );

    void set_state(plee_state_name state);
    void start_action_parent(const std::string action);

    bool is_crushed() const;

    void set_jump_time_ratio( double r );
    double get_jump_time_ratio() const;

    void regenerate();

    void create_stone( const bear::universe::force_type& a );
    void receive_energy(unsigned int energy);

    unsigned int get_stones_count() const;
    bool has_positive_orientation() const;

    void set_status_look_up(bool status);
    bool get_status_look_up() const;
    void set_status_crouch(bool status);
    bool get_status_crouch() const;

    void do_start_look_up();
    void do_start_crouch();

  protected:
    virtual void inform_no_energy();
    void to_string( std::string& str ) const;

  private:
    void do_get_camera();
    void do_die();
    void do_stop_look_up();
    void do_stop_crouch();
    void progress_spot( bear::universe::time_type elapsed_time );

  public:
    /** \brief The maximu energy of Plee. */
    static const unsigned int s_max_energy;

  private:
    /** \brief What the plee is doing. */
    action m_current_action;

    /** \brief Last saved position. */
    bear::universe::position_type m_saved_position;

    /** \brief The different states of Plee. */
    std::vector<state_plee*> m_states;

    /** \brief The current state. */
    plee_state_name m_current_state;

    /** \brief Indicates the ratio of the length of preparation of the jump. */
    double m_jump_time_ratio;

    /** \brief Indicates if Plee go to the right. */
    bool m_positive_orientation;

    /** \brief The number of stones. */
    unsigned int m_stones_count;

    /** \brief Indicates if Plee look up. */
    bool m_status_look_up;

    /** \brief Indicates the time of the look_up. */
    bear::universe::time_type m_look_up_time;

    /** \brief Indicates if Plee crouch. */
    bool m_status_crouch;

    /** \brief Indicates the time of the crouch. */
    bear::universe::time_type m_crouch_time;

    /** \brief Number of states considered. */
    static const unsigned int s_states_cardinality;

    /** \brief  The time to crouch. */
    static const bear::universe::time_type s_time_to_crouch;

    /** \brief  The time to look_up. */
    static const bear::universe::time_type s_time_to_look_up;

  }; // class plee
} // namespace ptb

#endif // __PTB_PLEE_HPP__
