/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_wait.cpp
 * \brief Implementation of the ptb::state_wait class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/plee/state_wait.hpp"

#include <stdlib.h>
#include <time.h>

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::state_wait::state_wait( plee* plee_instance )
  : state_plee(plee_instance)
{

} // state_wait::state_wait()

/*----------------------------------------------------------------------------*/
/**
 * \brief Return the name of the state.
 */
std::string ptb::state_wait::get_name() const
{
  return "wait";
} // state_wait::get_name()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialization of this state.
 */
void ptb::state_wait::start()
{
  std::string s("wait");

  srand ( time(NULL) );
  if ( (rand() % 2) == 0 )
    s += "1";
  else
    s += "2";

  m_plee_instance->start_action_parent(s);
} // state_wait::start()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void ptb::state_wait::progress( bear::universe::time_type elapsed_time )
{
  super::progress(elapsed_time);
  
  if ( m_plee_instance->has_bottom_contact() )
    {
      if ( ! test_walk() )
        if ( m_plee_instance->is_finished() )
          m_plee_instance->set_state(plee::idle_state);        
    }
  else
    test_in_sky();
} // state_wait::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee look up.
 */
void ptb::state_wait::do_look_up()
{
  m_plee_instance->set_state(plee::look_up_state);
} // state_wait::do_look_up()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee crouch.
 */
void ptb::state_wait::do_crouch()
{
  m_plee_instance->set_state(plee::crouch_state);
} // state_wait::do_crouch()
