/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file state_look_up.cpp
 * \brief Implementation of the ptb::state_look_up class.
 * \author Sebastien Angibaud
 */
#include "ptb/item/plee/state_look_up.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
ptb::state_look_up::state_look_up( ptb::plee* plee_instance )
  : state_plee(plee_instance)
{

} // state_look_up::state_look_up()

/*----------------------------------------------------------------------------*/
/**
 * \brief Return the name of the state.
 */
std::string ptb::state_look_up::get_name() const
{
  return "look_up";
} // state_look_up::get_name()

/*----------------------------------------------------------------------------*/
/**
 * \brief Initialization of this state.
 */
void ptb::state_look_up::start()
{
  m_plee_instance->start_action_parent("look_up");
} // state_look_up::start()

/*---------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void ptb::state_look_up::progress( bear::universe::time_type elapsed_time )
{
  super::progress(elapsed_time);

  if ( m_plee_instance->has_bottom_contact() )
    test_walk();
  else
    test_in_sky();
} // state_look_up::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief Do a jump.
 */
void ptb::state_look_up::do_jump()
{
  if ( m_plee_instance->has_bottom_contact() )
    m_plee_instance->set_state(plee::start_jump_state);
} // state_look_up::do_jump()

/*----------------------------------------------------------------------------*/
/**
 * \brief Stop to look up.
 */
void ptb::state_look_up::do_stop_look_up()
{
   if ( m_plee_instance->get_status_crouch() ) 
    m_plee_instance->set_state(plee::crouch_state);
   else
     m_plee_instance->set_state(plee::idle_state);
} // state_look_up::do_stop_look_up()

/*----------------------------------------------------------------------------*/
/**
 * \brief Make the plee crouch.
 */
void ptb::state_look_up::do_crouch()
{
  m_plee_instance->set_state(plee::crouch_state);
} // state_look_up::do_crouch()


/*----------------------------------------------------------------------------*/
/**
 * \brief Continue to crouch.
 */
void ptb::state_look_up::do_continue_crouch()
{
  if ( !m_plee_instance->get_status_crouch() ) 
    m_plee_instance->do_start_crouch();
} // state_look_up::do_continue_crouch()
