/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file gossipy_item.hpp
 * \brief The class describing a item that speaks from the beginning.
 * \author Sbastien Angibaud
 */
#ifndef __PTB_GOSSIPY_ITEM_HPP__
#define __PTB_GOSSIPY_ITEM_HPP__

#include "ptb/item_that_speaks.hpp"
#include "engine/base_item.hpp"

namespace ptb
{
  /**
   * \brief The class describing a gossipy item.
   * \author Sbastien Angibaud
   */
  class gossipy_item:
    public item_that_speaks<bear::engine::base_item>
  {
  public:
    /** \brief The type of the parent class. */
    typedef item_that_speaks<bear::engine::base_item> super;

  public:
    gossipy_item();

    void start();
    void progress( bear::universe::time_type elapsed_time );

  private:
    /** \brief Tell if we are speaking. */
    bool m_speaking;

  }; // class gossipy_item
} // namespace ptb

#endif // __PTB_GOSSIPY_ITEM_HPP__
