/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file text_box.cpp
 * \brief Implementation of the ptb::text_box class.
 * \author Julien Jorge
 */
#include "ptb/frame/text_box.hpp"

#include "engine/font_factory.hpp"
#include "engine/game.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param owner The frame owning this component.
 */
ptb::text_box::text_box( frame* owner )
  : bear::gui::visual_component( owner )
{
  m_frame = new bear::gui::frame( this, NULL, NULL, NULL, create_background() );

  m_frame->set_background_alpha( 0.75 );

  m_text = new bear::gui::static_text
    ( m_frame,
      bear::engine::font_factory::create("font/fixed_yellow-10x20.png") );
} // text_box::text_box()

/*----------------------------------------------------------------------------*/
/**
 * \brief Set the text in the box.
 * \param text The text to set.
 */
void ptb::text_box::set_text( const std::string& text )
{
  m_text->set_text(text);
} // text_box::set_text()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the text in the box.
 */
const std::string& ptb::text_box::get_text() const
{
  return m_text->get_text();
} // text_box::get_text()

/*----------------------------------------------------------------------------*/
/**
 * \brief Event called when the component is resized.
 *
 * Fit the text component to the size of the frame.
 */
void ptb::text_box::on_resized()
{
  m_frame->set_size( get_size() );
  m_text->set_size( get_size() );
} // text_box::on_resized()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create the sprite of the horizontal borders.
 */
bear::visual::sprite* ptb::text_box::create_horizontal_border() const
{
  bear::engine::level_globals& glob =
    bear::engine::game::get_instance().current_level_globals();

  const bear::visual::image& img = glob.get_image("gfx/frame.tga");
  claw::math::rectangle<unsigned int> rect(0, 35, 32, 3);

  return new bear::visual::sprite( img, rect );
} // text_box::create_horizontal_border()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create the sprite of the vertical borders.
 */
bear::visual::sprite* ptb::text_box::create_vertical_border() const
{
  bear::engine::level_globals& glob =
    bear::engine::game::get_instance().current_level_globals();

  const bear::visual::image& img = glob.get_image("gfx/frame.tga");
  claw::math::rectangle<unsigned int> rect(35, 0, 3, 32);

  return new bear::visual::sprite( img, rect );
} // text_box::create_vertical_border()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create the sprite of the background.
 */
bear::visual::sprite* ptb::text_box::create_background() const
{
  bear::engine::level_globals& glob =
    bear::engine::game::get_instance().current_level_globals();

  const bear::visual::image& img = glob.get_image("gfx/frame.tga");
  claw::math::rectangle<unsigned int> rect(32, 32, 32, 32);

  return new bear::visual::sprite( img, rect );
} // text_box::create_background()
