/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file frame_main_menu.cpp
 * \brief Implementation of the ptb::frame_main_menu class.
 * \author Julien Jorge
 */
#include "ptb/frame/frame_main_menu.hpp"

#include "engine/controller_layout.hpp"
#include "engine/game.hpp"
#include "ptb/frame/frame_start_menu.hpp"
#include "ptb/frame/frame_configure.hpp"
#include "ptb/player_action.hpp"

/*----------------------------------------------------------------------------*/
const unsigned int ptb::frame_main_menu::s_pos_start = 0;
const unsigned int ptb::frame_main_menu::s_pos_configure = 1;
const unsigned int ptb::frame_main_menu::s_pos_quit = 2;

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param owning_layer The layer onwing the window.
 */
ptb::frame_main_menu::frame_main_menu( windows_layer* owning_layer )
  : menu_frame(owning_layer)
{
  create_controls();

  if ( bear::engine::game::get_instance().get_rules().get_layout(1).empty() )
    default_controls_for_player_1();

  if ( bear::engine::game::get_instance().get_rules().get_layout(2).empty() )
    default_controls_for_player_2();
} // frame_main_menu::frame_main_menu()

/*----------------------------------------------------------------------------*/
/**
 * \brief Validate the selected action.
 */
void ptb::frame_main_menu::validate() const
{
  switch ( get_menu().cursor_position() )
    {
    case s_pos_start:
      show_window( new frame_start_menu(m_owning_layer) ); break;
    case s_pos_configure:
      show_window( new frame_configure(m_owning_layer,true) ); break;
    case s_pos_quit:
      bear::engine::game::get_instance().end();
      break;
    }
} // frame_main_menu::validate()

/*----------------------------------------------------------------------------*/
/**
 * \brief Create the static text components.
 */
void ptb::frame_main_menu::create_controls()
{
  char* strings[] = { "start_game", "configure", "quit", NULL };

  get_menu().make(strings);
  set_size( get_menu().get_size() );
} // frame_main_menu::create_controls()

/*----------------------------------------------------------------------------*/
/**
 * \brief Method called before closing the window.
 * \return True if the window can be closed.
 */
bool ptb::frame_main_menu::on_close()
{
  return false;
} // frame_main_menu::on_close()

/*----------------------------------------------------------------------------*/
/**
 * \brief Define the default controls for the first player.
 */
void ptb::frame_main_menu::default_controls_for_player_1() const
{
  bear::engine::controller_layout layout =
    bear::engine::game::get_instance().get_rules().get_layout(1);

  layout(bear::input::keyboard::kc_left) = player_action::move_left;
  layout(bear::input::keyboard::kc_right) = player_action::move_right;
  layout(bear::input::keyboard::kc_up) = player_action::look_up;
  layout(bear::input::keyboard::kc_down) = player_action::crouch;
  layout(bear::input::keyboard::kc_right_shift) = player_action::slap;
  layout(bear::input::keyboard::kc_right_control) = player_action::throw_stone;
  layout(bear::input::keyboard::kc_keypad_1) = player_action::drop;
  layout(bear::input::keyboard::kc_keypad_0) = player_action::jump;
  layout(bear::input::keyboard::kc_new_line) = player_action::speak;
  layout(bear::input::keyboard::kc_page_down) = player_action::get_camera;

  bear::engine::game::get_instance().get_rules().set_layout(1, layout);
} // frame_main_menu::default_controls_for_player_1()

/*----------------------------------------------------------------------------*/
/**
 * \brief Define the default controls for the second player.
 */
void ptb::frame_main_menu::default_controls_for_player_2() const
{
  bear::engine::controller_layout layout =
    bear::engine::game::get_instance().get_rules().get_layout(2);

  layout(bear::input::keyboard::kc_s) = player_action::move_left;
  layout(bear::input::keyboard::kc_f) = player_action::move_right;
  layout(bear::input::keyboard::kc_e) = player_action::look_up;
  layout(bear::input::keyboard::kc_d) = player_action::crouch;
  layout(bear::input::keyboard::kc_z) = player_action::slap;
  layout(bear::input::keyboard::kc_g) = player_action::throw_stone;
  layout(bear::input::keyboard::kc_q) = player_action::drop;
  layout(bear::input::keyboard::kc_r) = player_action::jump;
  layout(bear::input::keyboard::kc_z) = player_action::speak;
  layout(bear::input::keyboard::kc_c) = player_action::get_camera;

  bear::engine::game::get_instance().get_rules().set_layout(2, layout);
} // frame_main_menu::default_controls_for_player_2()
