/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file enemy_counter.hpp
 * \brief A class that counts instances of enemies.
 * \author Julien Jorge
 */

namespace ptb
{
  /**
   * \brief A class that counts instances of enemies.
   *
   * The count is done with a static variable. While static variables are
   * template dependants, this class must be outside the inheritance to
   * bear::engine::base_item.
   *
   * \author Julien Jorge
   */
  class enemy_counter
  {
  public:
    enemy_counter();
    ~enemy_counter();

  private:
    /** \brief Number of instances. */
    static unsigned int s_instances_count;

  }; // class enemy_counter
} // namespace ptb
