/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file item_that_speaks.cpp
 * \brief Implementation of the bear::engine::item_that_speaks class.
 * \author Sebastien Angibaud
 */

#include "engine/string_base.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Set a field of type list of string.
 * \param name The name of the field.
 * \param value The new value of the field.
 * \return false if the field "name" is unknow, true otherwise.
 *
 * Valid values for the \a name and \a value parameters are :
 *  - "speech", string
 *  - anything supported by the parent class
 */
template<class Base>
bool ptb::item_that_speaks<Base>::set_string_list_field
( const std::string& name, const std::vector<std::string>& value )
{
  bool ok = true;
  
  if (name == "speeches")
    {
      std::vector<std::string>::const_iterator it;
	
      for ( it = value.begin(); it != value.end(); ++it )
        {
          std::string speech(*it);
          bear::engine::string_base::get_instance().get_string(speech);
       
          add_speech(speech);
        }
    }
  else
    ok = super::set_string_list_field(name, value);

  return ok;
} // item_that_speaks::set_string_field()
