/*
  Plee The Bear

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file base_train_captive.cpp
 * \brief Implementation of the bear::base_train_captive class.
 * \author Sebastien Angibaud
 */
#include "ptb/base_train_captive.hpp"
#include "ptb/player_action.hpp"

#include "engine/export.hpp"

BASE_ITEM_EXPORT( base_train_captive, ptb )

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
  ptb::base_train_captive::base_train_captive()
{
  m_captive = false;
  m_end_captive = false;
} // base_train_captive::base_train_captive()

/*----------------------------------------------------------------------------*/
/**
 * \brief Do one iteration in the progression of the item.
 * \param elapsed_time Elapsed time since the last call.
 */
void ptb::base_train_captive::progress( bear::universe::time_type elapsed_time )
{
  super::progress( elapsed_time );

  if ( ! m_players.empty() )
    {
      bear::time_ref::time_reference current_time;
      current_time.set();

      if ( current_time - m_captive_time >= 4000 )
        {
          std::list<bear::engine::player*>::iterator it;

          for ( it = m_players.begin(); it != m_players.end(); ++it )
            (*it)->do_action(ptb::player_action::unchain);
	
          m_players.clear();
          m_end_captive = true;
        }
    }
} // base_train_captive::progress()

/*----------------------------------------------------------------------------*/
/**
 * \brief Tell that the item has a contact on its top.
 */
void ptb::base_train_captive::set_top_contact
(bear::universe::physical_item_state& item)
{
  super::set_top_contact(item);

  bear::engine::player* obj = dynamic_cast<bear::engine::player*>(&item);

  if (obj)
    if ( obj->is_player()  && ! m_captive )
      {
        m_players.push_back(obj);
        obj->do_action(player_action::chain);
        m_captive_time.set();
        m_captive = true;
      }
} // base_train_captive::set_top_contact()

/*----------------------------------------------------------------------------*/
/**
 * \brief Apply the movement of the item.
 * \param elapsed_time Elasped time since the last progress.
 */
void ptb::base_train_captive::move( bear::universe::time_type elapsed_time )
{
  /*
   * Replace with something like

   move_items(); // from the superclass

   if ( m_end_captive )
    m_list_items.clear();
  */
  /*super::super::move(elapsed_time);

  std::list<bear::universe::physical_item_state*>::iterator it;
  bear::universe::position_type position = get_position();

  for(it = m_list_items.begin(); it != m_list_items.end(); ++it)
    {
      // move items
      bear::universe::position_type pos = (*it)->get_position();
      pos += position - m_last_position;
      (*it)->set_position(pos);
    }

  if ( m_end_captive )
    m_list_items.clear();

  m_last_position = position;*/
} // base_train_captive::move()
