/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file node_compiler_model_description.cpp
 * \brief Implementation of the mc::node_compiler_model_description class.
 * \author Julien Jorge
 */
#include "mc/node_compiler/node_compiler_model_description.hpp"

#include <claw/assert.hpp>
#include "mc/model_grammar.hpp"
#include "mc/symbol_table.hpp"
#include "mc/node_compiler/node_compiler_model_atom.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Compile a node of type model.
 * \param The model we are compiling.
 * \param node Node to compile.
 */
void mc::node_compiler_model_description::compile_node
( model& the_model, const tree_node& node ) const
{
  CLAW_PRECOND( node.value.id() == model_grammar::id_model_description );

  symbol_table symbols;

  tree_node::const_tree_iterator it;
  node_compiler_model_atom comp_atom;

  for (it=node.children.begin(); it!=node.children.end(); ++it)
    comp_atom.compile_node( symbols, the_model, *it );
} // node_compiler_model_description::compile_node()
