/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file node_compiler.cpp
 * \brief Implementation of the mc::node_compiler class.
 * \author Julien Jorge
 */
#include "mc/node_compiler/node_compiler.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Write an error on the standard error stream.
 * \param first Begining of the incorrect input.
 * \param last End of the incorrect input.
 * \param msg Informative message.
 */
void mc::node_compiler::error( data_iterator first, data_iterator last,
                               const std::string& msg ) const
{
  boost::spirit::file_position pos = first.get_position();

  std::cerr << pos.file << ":" << pos.line << ":" << pos.column << ": " << msg
            << std::endl;
} // node_compiler::error()
