/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file image_type.hpp
 * \brief Image type.
 * \author Julien Jorge
 */
#ifndef __MC_IMAGE_TYPE__
#define __MC_IMAGE_TYPE__

#include <string>

#include "mc/compiled_file.hpp"

namespace mc
{
  /**
   * \brief Image type.
   * \author Julien Jorge
   */
  class image_type
  {
  public:
    image_type();
    image_type( const std::string& name, unsigned int top, unsigned int left,
                unsigned int width, unsigned int height );

    void output( compiled_file& f ) const;

    void set_image_file( const std::string& file );
    void set_top( const unsigned int top );
    void set_left( const unsigned int left );
    void set_width( const unsigned int width );
    void set_height( const unsigned int height );
    void set_flip_x( bool b );
    void set_flip_y( bool b );
    void set_alpha( float alpha );

  private:
    /** \brief The path to the image to use. */
    std::string m_image_file;

    /** \brief Y-coordinate. */
    unsigned int m_top;

    /** \brief X-coordinate. */
    unsigned int m_left;

    /** \brief Width. */
    unsigned int m_width;

    /** \brief Height. */
    unsigned int m_height;

    /** \brief Flip the image horizontaly. */
    bool m_flip_x;

    /** \brief Flip the image verticaly. */
    bool m_flip_y;

    /** \brief Alpha transparency. */
    float m_alpha;

  }; // class image_type
} // namespace mc

#endif // __MC_IMAGE_TYPE__
