/*
  Plee The Bear - Model compiler

  Copyright (C) 2005-2008 Julien Jorge, Sébastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file mc/code/resource.cpp
 * \brief Implementation of the mc::resource class.
 * \author Julien Jorge
 */
#include "mc/resource.hpp"

/*----------------------------------------------------------------------------*/
/**
 * \brief Default constructor.
 */
mc::resource::resource()
  : m_name(""), m_filename("")
{

} // resource::resource()

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 * \param name The name of the resource.
 * \param file the file of the resource.
 * \param global Tell if the resource is global.
 */
mc::resource::resource( const std::string& name, const std::string& file )
  : m_name(name), m_filename(file)
{

} // resource::resource()

/*----------------------------------------------------------------------------*/
/**
 * \brief Get the resource file.
 */
const std::string& mc::resource::get_file() const
{
  return m_filename;
} // resource::get_file()
