/*
  Plee The Bear - Level compiler

  Copyright (C) 2005-2008 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file bf/sprite.hpp
 * \brief The value of a field of type "sprite".
 * \author Julien Jorge
 */
#ifndef __BF_SPRITE__
#define __BF_SPRITE__

#include "bf/compiled_file.hpp"

namespace bf
{
  /**
   * \brief Sprite type.
   * \author Julien Jorge
   */
  class sprite
  {
  public:
    sprite();

    void set_image_name( const std::string& name );
    void set_top( const unsigned int top );
    void set_left( const unsigned int left );
    void set_clip_width( const unsigned int width );
    void set_clip_height( const unsigned int height );
    void set_width( const unsigned int width );
    void set_height( const unsigned int height );
    void set_flip_x( bool b );
    void set_flip_y( bool b );
    void set_alpha( double alpha );

    unsigned int get_left() const;
    unsigned int get_top() const;
    unsigned int get_clip_width() const;
    unsigned int get_clip_height() const;
    unsigned int get_width() const;
    unsigned int get_height() const;
    bool get_flip_x() const;
    bool get_flip_y() const;
    double get_alpha() const;
    const std::string& get_image_name() const;   

    void compile( compiled_file& f ) const;

  private:
    /** \brief The name of the image resource to use. */
    std::string m_image_name;

    /** \brief Y-coordinate. */
    unsigned int m_top;

    /** \brief X-coordinate. */
    unsigned int m_left;

    /** \brief Width in the source image. */
    unsigned int m_clip_width;

    /** \brief Height in the source image. */
    unsigned int m_clip_height;

    /** \brief Width on the screen. */
    unsigned int m_width;

    /** \brief Height on the screen. */
    unsigned int m_height;

    /** \brief Flip the sprite horizontaly. */
    bool m_flip_x;

    /** \brief Flip the sprite verticaly. */
    bool m_flip_y;

    /** \brief Alpha transparency. */
    double m_alpha;

  }; // class sprite
} // namespace bf

#endif // __BF_SPRITE__
